/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.okx.api.v5.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.stream.Argument;
import java.util.List;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OkxOutboundMessage
implements OutboundMessage {
    @JsonIgnore
    @NonNull
    protected OutboundMessage.MessageType messageType;
    private String op;
    private List<Argument> args;

    public OkxOutboundMessage(OutboundMessage.MessageType type, Argument arg) {
        if (type == OutboundMessage.MessageType.SUBSCRIPTION) {
            this.setOp("subscribe");
        } else if (type == OutboundMessage.MessageType.UNSUBSCRIBE) {
            this.setOp("unsubscribe");
        } else if (type == OutboundMessage.MessageType.LOGON) {
            this.setOp("login");
        }
        this.messageType = type;
        this.args = List.of(arg);
    }

    public static OkxOutboundMessage subscribe(Argument arg) {
        return new OkxOutboundMessage(OutboundMessage.MessageType.SUBSCRIPTION, arg);
    }

    public static OkxOutboundMessage unsubscribe(Argument arg) {
        return new OkxOutboundMessage(OutboundMessage.MessageType.UNSUBSCRIBE, arg);
    }

    public static OkxOutboundMessage login(String apiKey, String passphrase, Long timestamp, String sign) {
        Argument arg = Argument.createLoginArgument(apiKey, passphrase, timestamp, sign);
        return new OkxOutboundMessage(OutboundMessage.MessageType.LOGON, arg);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OkxOutboundMessage)) {
            return false;
        }
        OkxOutboundMessage other = (OkxOutboundMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OutboundMessage.MessageType this$messageType = this.getMessageType();
        OutboundMessage.MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType)) {
            return false;
        }
        String this$op = this.getOp();
        String other$op = other.getOp();
        if (this$op == null ? other$op != null : !this$op.equals(other$op)) {
            return false;
        }
        List<Argument> this$args = this.getArgs();
        List<Argument> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OkxOutboundMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OutboundMessage.MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        String $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : $op.hashCode());
        List<Argument> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    @Override
    @NonNull
    public OutboundMessage.MessageType getMessageType() {
        return this.messageType;
    }

    public String getOp() {
        return this.op;
    }

    public List<Argument> getArgs() {
        return this.args;
    }

    @JsonIgnore
    public void setMessageType(@NonNull OutboundMessage.MessageType messageType) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        this.messageType = messageType;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public void setArgs(List<Argument> args2) {
        this.args = args2;
    }

    public String toString() {
        return "OkxOutboundMessage(super=" + super.toString() + ", messageType=" + this.getMessageType() + ", op=" + this.getOp() + ", args=" + this.getArgs() + ")";
    }
}

