/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.okx.api.v5.lib;

import estonlabs.cxtl.common.AbstractExchangeFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.request.CancelRequest;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.request.CandleRequest;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.request.OrderQueryRequest;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.request.OrderRequest;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.OkxTicker;
import estonlabs.cxtl.exchanges.okx.api.v5.lib.OkxRestClient;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class OkxExchangeFactory
extends AbstractExchangeFactory<OrderRequest, CancelRequest, OrderQueryRequest, CandleRequest, OkxTicker, OkxRestClient, OkxExchangeFactory> {
    public static final URI PROD = URI.create("https://www.okx.com");
    public static final URI TEST_NET = URI.create("https://www.okx.com");
    private static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD), EnvironmentType.TEST_NET, List.of(TEST_NET));
    private final URI baseUri;
    private final EnvironmentType env;

    public OkxExchangeFactory(EnvironmentType env, URI baseUri) {
        super(Exchange.OKX, ENVIRONMENTS);
        this.baseUri = baseUri;
        this.env = env;
    }

    @Override
    public OkxRestClient buildCex() {
        return this.buildCex(this.httpProxy);
    }

    @Override
    public OkxRestClient buildCex(Proxy httpProxy) {
        return new OkxRestClient(this.createJsonRestClient(this.baseUri, httpProxy), this.env, this.baseUri, this.metricsLogger);
    }

    @Override
    protected OkxExchangeFactory me() {
        return this;
    }

    @Override
    public OkxRestClient buildEdi() {
        return this.buildCex();
    }

    @Override
    public OkxRestClient buildEdi(Proxy httpProxy) {
        return this.buildCex(httpProxy);
    }
}

