/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.okx.api.v5.lib;

import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.exception.CxtlApiException;
import estonlabs.cxtl.common.exception.ErrorCode;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.JsonRestClient;
import estonlabs.cxtl.common.http.Method;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.common.http.RestClient;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.Trade;
import estonlabs.cxtl.exchanges.a.specification.lib.Cex;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeDataInterface;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.request.CancelRequest;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.request.CandleRequest;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.request.OrderQueryRequest;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.request.OrderRequest;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.request.TickerRequest;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.request.TradeRequest;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.ApiResponse;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.CancelAckResponse;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.Candle;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.CandleResponse;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.CreateAckResponse;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.OkxAck;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.OkxOrder;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.OkxTicker;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.OkxTrade;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.OrderListResponse;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.OrderResponse;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.TickerListResponse;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.response.TradeListResponse;
import estonlabs.cxtl.exchanges.okx.api.v5.util.Util;
import java.net.Proxy;
import java.net.URI;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OkxRestClient
implements Cex<OrderRequest, CancelRequest, OrderQueryRequest>,
ExchangeDataInterface<OkxTicker, CandleRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OkxRestClient.class);
    private static final String ORDERS_URL = "/api/v5/trade/order";
    private static final String OPEN_ORDERS_URL = "/api/v5/trade/orders-pending";
    private static final String FILL_ORDERS_URL = "/api/v5/trade/orders-history";
    private static final String CANCEL_ORDER_URL = "/api/v5/trade/cancel-order";
    private static final String CANDLES_URL = "/api/v5/market/candles";
    private static final String TICKERS_URL = "/api/v5/public/instruments";
    private static final String TRADES_URL = "/api/v5/market/trades";
    private static final String API_HEADER_KEY = "OK-ACCESS-KEY";
    private static final String API_HEADER_SIGN = "OK-ACCESS-SIGN";
    private static final String API_HEADER_PASSPHRASE = "OK-ACCESS-PASSPHRASE";
    private static final String API_HEADER_TIMESTAMP = "OK-ACCESS-TIMESTAMP";
    private static final String API_HEADER_SIMULATED_TRADING = "x-simulated-trading";
    private final RestClientAdapter client;

    public OkxRestClient(JsonRestClient restClient, EnvironmentType env, URI baseUri, MetricsLogger metricsLogger) {
        this.client = new RestClientAdapter(restClient, env, baseUri, metricsLogger);
    }

    @Override
    public Proxy getProxy() {
        return this.client.client.getProxy();
    }

    @Override
    public Exchange getExchange() {
        return Exchange.OKX;
    }

    @Override
    public AssetClass[] getSupportedAssetClasses() {
        return new AssetClass[]{AssetClass.SPOT, AssetClass.PERP, AssetClass.FUTURE};
    }

    @Override
    @NotNull
    public Mono<OkxAck> placeOrder(@NotNull Credentials credentials, @NotNull OrderRequest order) {
        return this.client.post(credentials, ORDERS_URL, order, CreateAckResponse.class);
    }

    @Override
    @NotNull
    public Mono<OkxAck> cancelOrder(@NotNull Credentials credentials, @NotNull CancelRequest request) {
        return this.client.post(credentials, CANCEL_ORDER_URL, request, CancelAckResponse.class);
    }

    @Override
    @NotNull
    public Mono<List<OkxOrder>> getOrders(@NotNull Credentials credentials, OrderQueryRequest orderQueryRequest) {
        Mono openOrders = Mono.just(List.of());
        Mono fillOrders = Mono.just(List.of());
        if (orderQueryRequest.getOrderStatus() == null || "OPEN".equals(orderQueryRequest.getOrderStatus())) {
            openOrders = this.client.get(credentials, OPEN_ORDERS_URL, orderQueryRequest, OrderListResponse.class).switchIfEmpty(Mono.just(List.of()));
        }
        if (orderQueryRequest.getOrderStatus() == null || !"OPEN".equals(orderQueryRequest.getOrderStatus())) {
            fillOrders = this.client.get(credentials, FILL_ORDERS_URL, orderQueryRequest, OrderListResponse.class).switchIfEmpty(Mono.just(List.of()));
        }
        return Mono.zip(openOrders, fillOrders).flatMap(tuple -> {
            ArrayList combinedList = new ArrayList();
            combinedList.addAll((Collection)tuple.getT1());
            combinedList.addAll((Collection)tuple.getT2());
            return Mono.just(combinedList);
        });
    }

    @Override
    public Mono<? extends Order> getOrder(Credentials credentials, OrderQueryRequest orderQueryRequest) {
        LOGGER.info("orderQueryRequest {}", (Object)orderQueryRequest);
        return this.client.get(credentials, ORDERS_URL, orderQueryRequest, OrderResponse.class).flatMapMany(Flux::fromIterable).next();
    }

    @Override
    public Mono<List<Candle>> getOlhcv(CandleRequest request) {
        LOGGER.info("request {}", (Object)request);
        return this.client.get(CANDLES_URL, request, CandleResponse.class).switchIfEmpty(Mono.just(List.of()));
    }

    @Override
    public Mono<? extends List<? extends Trade>> getLatestPublicTrades(AssetClass assetClass, String symbol) {
        return this.getLatestPublicTrades(assetClass, symbol, 100);
    }

    public Mono<List<OkxTrade>> getLatestPublicTrades(AssetClass assetClass, String symbol, Integer limit) {
        String url = String.format(TRADES_URL, symbol);
        TradeRequest tradeReq = new TradeRequest();
        if (limit == null) {
            limit = 100;
        }
        tradeReq.setLimit(limit.toString());
        tradeReq.setInstId(symbol);
        return this.fetchTrades(url, tradeReq);
    }

    private Mono<List<OkxTrade>> fetchTrades(String url, TradeRequest query) {
        return this.client.get(url, query, TradeListResponse.class).switchIfEmpty(Mono.just(List.of()));
    }

    @Override
    public Mono<Map<AssetClass, List<OkxTicker>>> getTickers() {
        return Mono.zip(this.getTickers(AssetClass.SPOT), this.getTickers(AssetClass.PERP), this.getTickers(AssetClass.FUTURE)).map(tuple -> Map.of(AssetClass.SPOT, (List)tuple.getT1(), AssetClass.PERP, (List)tuple.getT2(), AssetClass.FUTURE, (List)tuple.getT3()));
    }

    public Mono<List<OkxTicker>> getTickers(AssetClass assetClass) {
        if (Arrays.stream(this.getSupportedAssetClasses()).noneMatch(ac -> ac == assetClass)) {
            return Mono.error(new CxtlApiException("Asset class not supported", "ASSET_CLASS_NOT_SUPPORTED", ErrorCode.INVALID_SYMBOL));
        }
        TickerRequest req = new TickerRequest();
        req.setInstType(Util.toInstrumentType(assetClass));
        return this.client.get(TICKERS_URL, req, TickerListResponse.class).doOnError(e -> LOGGER.error("Error fetching tickers", (Throwable)e)).switchIfEmpty(Mono.just(List.of()));
    }

    private static ErrorCode errorCode(String strCode) {
        int code = Integer.parseInt(strCode);
        return switch (code) {
            case 51008 -> ErrorCode.INSUFFICIENT_BALANCE;
            case 51046, 51047, 51048, 51049, 51050, 51051, 51052, 51053, 51122 -> ErrorCode.BAD_PX;
            case 51000, 51185 -> ErrorCode.INVALID_QTY;
            case 51001 -> ErrorCode.INVALID_SYMBOL;
            case 51400 -> ErrorCode.UNKNOWN_ORDER;
            case 51016, 51603 -> ErrorCode.INVALID_ARGUMENT;
            default -> ErrorCode.UNKNOWN_ERROR;
        };
    }

    private static String createTimestamp() {
        Instant now = Instant.now();
        OffsetDateTime offsetDateTime = now.atOffset(ZoneOffset.UTC);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        return formatter.format(offsetDateTime);
    }

    public static class RestClientAdapter {
        private final RestClient client;
        private final MetricsLogger metricsLogger;
        private final EnvironmentType env;

        public RestClientAdapter(RestClient client, EnvironmentType env, URI baseUri, MetricsLogger metricsLogger) {
            this.client = client;
            this.metricsLogger = metricsLogger;
            this.env = env;
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> get(String path, IN request, Class<RESPONSE> type) {
            return this.client.get(path, request, type).flatMap(this::handleResponse);
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> get(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.get((Request.Builder builder, String json) -> this.addHeaders(credentials, builder, Method.GET, path, json), path, request, type).flatMap(this::handleResponse);
        }

        public <OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> get(Credentials credentials, String path, Class<RESPONSE> type) {
            return this.client.get((Request.Builder builder, String json) -> this.addHeaders(credentials, builder, Method.GET, path, json), path, type).flatMap(this::handleResponse);
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> post(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.postAsJson((builder, json) -> this.addHeaders(credentials, builder, Method.POST, path, json), path, request, type).flatMap(this::handleResponse);
        }

        public <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> delete(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.deleteAsForm((builder, json) -> this.addHeaders(credentials, builder, Method.DELETE, path, json), path, request, type).flatMap(this::handleResponse);
        }

        private <IN, OUT, RESPONSE extends ApiResponse<OUT>> Mono<OUT> handleResponse(Event<RESPONSE> event) {
            ApiResponse response = (ApiResponse)event.getResponse();
            if (!response.isSuccess()) {
                this.metricsLogger.finishedError(event);
                return Mono.error(new CxtlApiException(response.getMessage(), null, OkxRestClient.errorCode(response.getCode())));
            }
            return Mono.just(((ApiResponse)event.getResponse()).getData()).doFinally(v -> this.metricsLogger.finishedSuccess(event));
        }

        public Request.Builder addHeaders(Credentials credentials, Request.Builder builder, Method method, String requestPath, String request) {
            String timestamp = OkxRestClient.createTimestamp();
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append(timestamp).append(method.name()).append(requestPath);
            if (Method.GET.equals((Object)method) && !request.isEmpty()) {
                messageBuilder.append("?");
            }
            messageBuilder.append(request);
            String originToSign = messageBuilder.toString();
            String signature = Util.sign(credentials, originToSign);
            builder = builder.addHeader(OkxRestClient.API_HEADER_PASSPHRASE, credentials.getPassword()).addHeader(OkxRestClient.API_HEADER_KEY, credentials.getApiKey()).addHeader(OkxRestClient.API_HEADER_SIGN, signature).addHeader(OkxRestClient.API_HEADER_TIMESTAMP, timestamp);
            return builder;
        }
    }
}

