/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.okx.api.v5.lib;

import estonlabs.cxtl.common.AbstractStreamFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.stream.OkxInboundContainer;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.stream.OkxOutboundMessage;
import estonlabs.cxtl.exchanges.okx.api.v5.util.Util;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class OkxStreamFactory
extends AbstractStreamFactory<OkxOutboundMessage, OkxInboundContainer, OkxStreamFactory> {
    public static final URI PROD = URI.create("wss://ws.okx.com:8443/ws/v5");
    public static final URI TEST_NET = URI.create("wss://ws.okx.com:8443/ws/v5");
    public static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD), EnvironmentType.TEST_NET, List.of(TEST_NET));
    private static final Codec<Object> CODEC = new JacksonCodec();
    private final URI baseUri;

    public OkxStreamFactory() {
        this(PROD);
    }

    public OkxStreamFactory(URI baseUri) {
        super(Exchange.OKX, CODEC, OkxInboundContainer.class);
        this.baseUri = baseUri;
    }

    public static OkxStreamFactory create(URI uri) {
        return new OkxStreamFactory(uri);
    }

    public static OkxStreamFactory prod() {
        return new OkxStreamFactory(PROD);
    }

    @Override
    protected OkxStreamFactory me() {
        return this;
    }

    public WebsocketConnection<OkxOutboundMessage, OkxInboundContainer> createPublicStream() {
        String url = this.baseUri.toString();
        return this.newPublicWebsocket(URI.create(url + "/public"), null);
    }

    public WebsocketConnection<OkxOutboundMessage, OkxInboundContainer> createPrivateStream(@NonNull Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        return this.createPrivateStream(credentials, this.httpProxy);
    }

    public WebsocketConnection<OkxOutboundMessage, OkxInboundContainer> createPrivateStream(@NonNull Credentials credentials, Proxy httpProxy) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        String url = this.baseUri.toString() + "/private";
        return this.newPrivateWebsocket(URI.create(url), null, httpProxy, session -> {
            session.enableLogin(() -> {
                Long timestamp = System.currentTimeMillis() / 1000L;
                String loginStr = timestamp + "GET/users/self/verify";
                String sign = Util.sign(credentials, loginStr);
                return OkxOutboundMessage.login(credentials.getApiKey(), credentials.getPassword(), timestamp, sign);
            });
            return session;
        });
    }
}

