/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.okx.api.v5.util;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.security.HmacUtils;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.types.InstrumentType;
import estonlabs.cxtl.exchanges.okx.api.v5.domain.types.TradeMode;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import org.bouncycastle.util.encoders.Base64;

public class Util {
    public static InstrumentType toInstrumentType(AssetClass assetClass) {
        if (assetClass == AssetClass.SPOT) {
            return InstrumentType.SPOT;
        }
        if (assetClass == AssetClass.FUTURE) {
            return InstrumentType.FUTURES;
        }
        if (assetClass == AssetClass.PERP) {
            return InstrumentType.SWAP;
        }
        return null;
    }

    public static TradeMode toTradeMode(AssetClass assetClass) {
        if (assetClass == AssetClass.SPOT) {
            return TradeMode.cash;
        }
        return TradeMode.cross;
    }

    public static String sign(Credentials credentials, String sb) {
        byte[] bytes = sb.getBytes();
        try {
            Mac hmacSha256 = HmacUtils.getMac(credentials);
            byte[] hash = hmacSha256.doFinal(bytes);
            return new String(Base64.encode(hash));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

