/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.woox.api.vX.domain.data;

import kotlin.Pair;

public enum AssetType {
    SPOT,
    PERP;

    private static final String EMPTY = "";

    public static AssetType getAssetType(String ticker) {
        if (ticker.startsWith(SPOT.name())) {
            return SPOT;
        }
        if (ticker.startsWith(PERP.name())) {
            return PERP;
        }
        return null;
    }

    public Pair<String, String> getAssets(String ticker) {
        String[] parts = ticker.split("_");
        if (parts.length >= 2) {
            String asset1 = parts[parts.length - 2];
            String asset2 = parts[parts.length - 1];
            return new Pair<String, String>(asset1, asset2);
        }
        return null;
    }

    public String getNormalizedTicker(String ticker) {
        return this.getNormalizedTicker(ticker, EMPTY);
    }

    public String getNormalizedTicker(String ticker, String delimiter) {
        return ticker.replace(this.name() + "_", EMPTY).replace("_", delimiter);
    }
}

