/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.woox.api.vX.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketDataWithSymbol;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.stream.WooXInboundMessage;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class L1OrderBookResponse
extends WooXInboundMessage
implements MarketDataWithSymbol {
    private final boolean snapshot = true;
    @JsonProperty(value="topic")
    private String topic;
    @JsonProperty(value="ts")
    private Long timestamp;
    @JsonProperty(value="data")
    private L1Data data;

    public L1OrderBookResponse() {
        super(InboundMessage.MessageType.DATA);
    }

    @Override
    public Long getSeqNo() {
        return this.getTimestamp();
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public String getSymbol() {
        return this.data.symbol;
    }

    @Override
    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public L1Data getData() {
        return this.data;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class L1Data {
        private final boolean snapshot = true;
        @JsonProperty(value="symbol")
        private String symbol;
        @JsonProperty(value="ask")
        private Double ask;
        @JsonProperty(value="askSize")
        private Double askSize;
        @JsonProperty(value="bid")
        private Double bid;
        @JsonProperty(value="bidSize")
        private Double bidSize;

        public boolean isSnapshot() {
            Objects.requireNonNull(this);
            return true;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public Double getAsk() {
            return this.ask;
        }

        public Double getAskSize() {
            return this.askSize;
        }

        public Double getBid() {
            return this.bid;
        }

        public Double getBidSize() {
            return this.bidSize;
        }

        @JsonProperty(value="symbol")
        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        @JsonProperty(value="ask")
        public void setAsk(Double ask) {
            this.ask = ask;
        }

        @JsonProperty(value="askSize")
        public void setAskSize(Double askSize) {
            this.askSize = askSize;
        }

        @JsonProperty(value="bid")
        public void setBid(Double bid) {
            this.bid = bid;
        }

        @JsonProperty(value="bidSize")
        public void setBidSize(Double bidSize) {
            this.bidSize = bidSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof L1Data)) {
                return false;
            }
            L1Data other = (L1Data)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSnapshot() != other.isSnapshot()) {
                return false;
            }
            Double this$ask = this.getAsk();
            Double other$ask = other.getAsk();
            if (this$ask == null ? other$ask != null : !((Object)this$ask).equals(other$ask)) {
                return false;
            }
            Double this$askSize = this.getAskSize();
            Double other$askSize = other.getAskSize();
            if (this$askSize == null ? other$askSize != null : !((Object)this$askSize).equals(other$askSize)) {
                return false;
            }
            Double this$bid = this.getBid();
            Double other$bid = other.getBid();
            if (this$bid == null ? other$bid != null : !((Object)this$bid).equals(other$bid)) {
                return false;
            }
            Double this$bidSize = this.getBidSize();
            Double other$bidSize = other.getBidSize();
            if (this$bidSize == null ? other$bidSize != null : !((Object)this$bidSize).equals(other$bidSize)) {
                return false;
            }
            String this$symbol = this.getSymbol();
            String other$symbol = other.getSymbol();
            return !(this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol));
        }

        protected boolean canEqual(Object other) {
            return other instanceof L1Data;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSnapshot() ? 79 : 97);
            Double $ask = this.getAsk();
            result = result * 59 + ($ask == null ? 43 : ((Object)$ask).hashCode());
            Double $askSize = this.getAskSize();
            result = result * 59 + ($askSize == null ? 43 : ((Object)$askSize).hashCode());
            Double $bid = this.getBid();
            result = result * 59 + ($bid == null ? 43 : ((Object)$bid).hashCode());
            Double $bidSize = this.getBidSize();
            result = result * 59 + ($bidSize == null ? 43 : ((Object)$bidSize).hashCode());
            String $symbol = this.getSymbol();
            result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
            return result;
        }

        public String toString() {
            return "L1OrderBookResponse.L1Data(snapshot=" + this.isSnapshot() + ", symbol=" + this.getSymbol() + ", ask=" + this.getAsk() + ", askSize=" + this.getAskSize() + ", bid=" + this.getBid() + ", bidSize=" + this.getBidSize() + ")";
        }
    }
}

