/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.woox.api.vX.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketDataWithSymbol;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.stream.WooXInboundMessage;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderBookResponse
extends WooXInboundMessage
implements MarketDataWithSymbol {
    private final boolean snapshot = false;
    @JsonProperty(value="topic")
    private String topic;
    @JsonProperty(value="ts")
    private Long timestamp;
    @JsonProperty(value="data")
    private OrderBookData data;

    public OrderBookResponse() {
        super(InboundMessage.MessageType.DATA);
    }

    @Override
    public Long getSeqNo() {
        return this.getTimestamp();
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public String getSymbol() {
        return this.data.symbol;
    }

    @Override
    public boolean isSnapshot() {
        return this.snapshot;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public OrderBookData getData() {
        return this.data;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class OrderBookData {
        @JsonProperty(value="symbol")
        private String symbol;
        @JsonProperty(value="prevTs")
        private Long prevTs;
        @JsonProperty(value="asks")
        private List<List<Double>> asks;
        @JsonProperty(value="bids")
        private List<List<Double>> bids;

        public String getSymbol() {
            return this.symbol;
        }

        public Long getPrevTs() {
            return this.prevTs;
        }

        public List<List<Double>> getAsks() {
            return this.asks;
        }

        public List<List<Double>> getBids() {
            return this.bids;
        }

        @JsonProperty(value="symbol")
        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        @JsonProperty(value="prevTs")
        public void setPrevTs(Long prevTs) {
            this.prevTs = prevTs;
        }

        @JsonProperty(value="asks")
        public void setAsks(List<List<Double>> asks) {
            this.asks = asks;
        }

        @JsonProperty(value="bids")
        public void setBids(List<List<Double>> bids) {
            this.bids = bids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderBookData)) {
                return false;
            }
            OrderBookData other = (OrderBookData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$prevTs = this.getPrevTs();
            Long other$prevTs = other.getPrevTs();
            if (this$prevTs == null ? other$prevTs != null : !((Object)this$prevTs).equals(other$prevTs)) {
                return false;
            }
            String this$symbol = this.getSymbol();
            String other$symbol = other.getSymbol();
            if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
                return false;
            }
            List<List<Double>> this$asks = this.getAsks();
            List<List<Double>> other$asks = other.getAsks();
            if (this$asks == null ? other$asks != null : !((Object)this$asks).equals(other$asks)) {
                return false;
            }
            List<List<Double>> this$bids = this.getBids();
            List<List<Double>> other$bids = other.getBids();
            return !(this$bids == null ? other$bids != null : !((Object)this$bids).equals(other$bids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrderBookData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $prevTs = this.getPrevTs();
            result = result * 59 + ($prevTs == null ? 43 : ((Object)$prevTs).hashCode());
            String $symbol = this.getSymbol();
            result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
            List<List<Double>> $asks = this.getAsks();
            result = result * 59 + ($asks == null ? 43 : ((Object)$asks).hashCode());
            List<List<Double>> $bids = this.getBids();
            result = result * 59 + ($bids == null ? 43 : ((Object)$bids).hashCode());
            return result;
        }

        public String toString() {
            return "OrderBookResponse.OrderBookData(symbol=" + this.getSymbol() + ", prevTs=" + this.getPrevTs() + ", asks=" + this.getAsks() + ", bids=" + this.getBids() + ")";
        }
    }
}

