/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.woox.api.vX.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import estonlabs.cxtl.common.stream.managed.InboundMessage;
import estonlabs.cxtl.common.stream.managed.MarketDataWithSymbol;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.stream.WooXInboundMessage;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OrderBookSnapshot
extends WooXInboundMessage
implements MarketDataWithSymbol {
    private final boolean snapshot = true;
    @JsonProperty(value="data")
    private OrderBookData data;

    public OrderBookSnapshot() {
        super(InboundMessage.MessageType.DATA);
    }

    @Override
    public String getTopic() {
        return String.format("%s@orderbookupdate", this.data.getSymbol());
    }

    @Override
    public Long getSeqNo() {
        return this.getTimestamp();
    }

    @Override
    public Long getTimestamp() {
        return this.data.getTimestamp();
    }

    @Override
    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public String getSymbol() {
        return this.data.symbol;
    }

    @Override
    public boolean isSnapshot() {
        return this.snapshot;
    }

    public OrderBookData getData() {
        return this.data;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class OrderBookData {
        private final boolean snapshot = true;
        @JsonProperty(value="symbol")
        private String symbol;
        @JsonProperty(value="ts")
        private Long timestamp;
        @JsonProperty(value="asks")
        private List<List<Double>> asks;
        @JsonProperty(value="bids")
        private List<List<Double>> bids;

        public boolean isSnapshot() {
            Objects.requireNonNull(this);
            return true;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }

        public List<List<Double>> getAsks() {
            return this.asks;
        }

        public List<List<Double>> getBids() {
            return this.bids;
        }

        @JsonProperty(value="symbol")
        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        @JsonProperty(value="ts")
        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @JsonProperty(value="asks")
        public void setAsks(List<List<Double>> asks) {
            this.asks = asks;
        }

        @JsonProperty(value="bids")
        public void setBids(List<List<Double>> bids) {
            this.bids = bids;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderBookData)) {
                return false;
            }
            OrderBookData other = (OrderBookData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSnapshot() != other.isSnapshot()) {
                return false;
            }
            Long this$timestamp = this.getTimestamp();
            Long other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            String this$symbol = this.getSymbol();
            String other$symbol = other.getSymbol();
            if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
                return false;
            }
            List<List<Double>> this$asks = this.getAsks();
            List<List<Double>> other$asks = other.getAsks();
            if (this$asks == null ? other$asks != null : !((Object)this$asks).equals(other$asks)) {
                return false;
            }
            List<List<Double>> this$bids = this.getBids();
            List<List<Double>> other$bids = other.getBids();
            return !(this$bids == null ? other$bids != null : !((Object)this$bids).equals(other$bids));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrderBookData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSnapshot() ? 79 : 97);
            Long $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            String $symbol = this.getSymbol();
            result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
            List<List<Double>> $asks = this.getAsks();
            result = result * 59 + ($asks == null ? 43 : ((Object)$asks).hashCode());
            List<List<Double>> $bids = this.getBids();
            result = result * 59 + ($bids == null ? 43 : ((Object)$bids).hashCode());
            return result;
        }

        public String toString() {
            return "OrderBookSnapshot.OrderBookData(snapshot=" + this.isSnapshot() + ", symbol=" + this.getSymbol() + ", timestamp=" + this.getTimestamp() + ", asks=" + this.getAsks() + ", bids=" + this.getBids() + ")";
        }
    }
}

