/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.woox.api.vX.domain.stream;

import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.stream.SubscriptionType;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.stream.WooXOutboundMessage;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.stream.WooXOutboundSubscription;
import java.util.Map;

public class SubscriptionHelper {
    public static WooXOutboundMessage subscribe(String topic) {
        return new WooXOutboundSubscription(OutboundMessage.MessageType.SUBSCRIPTION, "subscribe", topic, Long.toString(System.currentTimeMillis()), null);
    }

    public static WooXOutboundMessage unsubscribe(String topic) {
        return new WooXOutboundSubscription(OutboundMessage.MessageType.UNSUBSCRIBE, "unsubscribe", topic, Long.toString(System.currentTimeMillis()), null);
    }

    public static WooXOutboundMessage subscribeL2(String symbol) {
        return SubscriptionHelper.subscribe(SubscriptionHelper.topic(SubscriptionType.ORDERBOOKUPDATE, symbol, null));
    }

    public static WooXOutboundMessage subscribeL2(String symbol, int level) {
        return SubscriptionHelper.subscribe(SubscriptionHelper.topic(SubscriptionType.ORDERBOOKUPDATE, symbol, level));
    }

    public static WooXOutboundMessage subscribeL1(String symbol) {
        return SubscriptionHelper.subscribe(SubscriptionHelper.topic(SubscriptionType.BBO, symbol, null));
    }

    public static WooXOutboundMessage unsubscribeL2(String symbol, int levels) {
        return SubscriptionHelper.unsubscribe(SubscriptionHelper.topic(SubscriptionType.ORDERBOOKUPDATE, symbol, levels));
    }

    public static WooXOutboundMessage unsubscribeL1(String symbol) {
        return SubscriptionHelper.unsubscribe(SubscriptionHelper.topic(SubscriptionType.BBO, symbol, null));
    }

    public static WooXOutboundMessage unsubscribeL2(String symbol) {
        return SubscriptionHelper.unsubscribe(SubscriptionHelper.topic(SubscriptionType.ORDERBOOKUPDATE, symbol, null));
    }

    public static WooXOutboundSubscription requestSnapshot(String id, String symbol) {
        return new WooXOutboundSubscription(OutboundMessage.MessageType.SNAPSHOT, "request", null, id, Map.of("type", "orderbook", "symbol", symbol));
    }

    public static WooXOutboundMessage executionReports() {
        return new WooXOutboundSubscription(OutboundMessage.MessageType.SUBSCRIPTION, "subscribe", SubscriptionType.EXECUTIONREPORT.name().toLowerCase(), Long.toString(System.currentTimeMillis()), null);
    }

    public static String topic(SubscriptionType type, String symbol, int granularity) {
        return SubscriptionHelper.topic(type, symbol, Integer.toString(granularity));
    }

    public static String topic(SubscriptionType type, String symbol) {
        return SubscriptionHelper.topic(type, symbol, null);
    }

    public static String topic(SubscriptionType type, String symbol, String granularity) {
        return symbol + "@" + type.name().toLowerCase() + (granularity == null ? "" : granularity);
    }
}

