/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.woox.api.vX.domain.stream;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import estonlabs.cxtl.common.stream.managed.OutboundMessage;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.stream.WooXOutboundMessage;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class WooXOutboundSubscription
extends WooXOutboundMessage {
    private final String id;
    private final String topic;
    private final Map<String, String> params;

    protected WooXOutboundSubscription(OutboundMessage.MessageType messageType, String event, String topic, String id, Map<String, String> params) {
        super(messageType, event);
        this.id = id;
        this.topic = topic;
        this.params = params;
    }

    public static WooXOutboundSubscription subscribe(String id, String topic) {
        return new WooXOutboundSubscription(OutboundMessage.MessageType.SUBSCRIPTION, "subscribe", topic, id, null);
    }

    public static WooXOutboundSubscription unsubscribe(String id, String topic) {
        return new WooXOutboundSubscription(OutboundMessage.MessageType.UNSUBSCRIBE, "unsubscribe", topic, id, null);
    }

    public static WooXOutboundSubscription requestSnapshot(String id, String symbol) {
        return new WooXOutboundSubscription(OutboundMessage.MessageType.SNAPSHOT, "request", null, id, Map.of("type", "orderbook", "symbol", symbol));
    }

    @Override
    public String toString() {
        return "WooXOutboundSubscription(super=" + super.toString() + ", id=" + this.getId() + ", topic=" + this.getTopic() + ", params=" + this.getParams() + ")";
    }

    public String getId() {
        return this.id;
    }

    public String getTopic() {
        return this.topic;
    }

    public Map<String, String> getParams() {
        return this.params;
    }
}

