/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.woox.api.vX.lib;

import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.exception.CxtlApiException;
import estonlabs.cxtl.common.exception.ErrorCode;
import estonlabs.cxtl.common.http.Event;
import estonlabs.cxtl.common.http.JsonRestClient;
import estonlabs.cxtl.common.http.Method;
import estonlabs.cxtl.common.http.MetricsLogger;
import estonlabs.cxtl.common.http.RestClient;
import estonlabs.cxtl.common.security.HmacUtils;
import estonlabs.cxtl.exchanges.a.specification.domain.Ack;
import estonlabs.cxtl.exchanges.a.specification.domain.AckStatus;
import estonlabs.cxtl.exchanges.a.specification.domain.AssetClass;
import estonlabs.cxtl.exchanges.a.specification.domain.DefaultAck;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.a.specification.domain.Olhcv;
import estonlabs.cxtl.exchanges.a.specification.domain.Order;
import estonlabs.cxtl.exchanges.a.specification.domain.Trade;
import estonlabs.cxtl.exchanges.a.specification.lib.Cex;
import estonlabs.cxtl.exchanges.a.specification.lib.ExchangeDataInterface;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.data.ApiResponse;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.data.AssetInfo;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.data.OrderAck;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.data.OrderStatus;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.data.WooMarketInfo;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.data.WooOrder;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.data.WooTicker;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.data.WooTrade;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.request.CancelOrderRequest;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.request.OrderQuery;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.request.OrderRequest;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.request.TradeRequest;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.response.ApiV3Response;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.response.AssetInfoResponse;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.response.ListV1Response;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.response.OrderQueryResponse;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.response.SingleOrderesponse;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.response.WooMarketInfoResponse;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.response.WooTradeResponse;
import java.net.Proxy;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class WooXRestClient
implements Cex<OrderRequest, CancelOrderRequest, OrderQuery>,
ExchangeDataInterface<WooTicker, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WooXRestClient.class);
    private final RestClientAdapter client;

    public WooXRestClient(JsonRestClient client, MetricsLogger metricsLogger) {
        this.client = new RestClientAdapter(client, metricsLogger);
    }

    @Override
    public Proxy getProxy() {
        return this.client.client.getProxy();
    }

    @Override
    public Mono<? extends List<? extends Trade>> getLatestPublicTrades(AssetClass assetClass, String symbol) {
        if (Arrays.stream(this.getSupportedAssetClasses()).noneMatch(ac -> ac == assetClass)) {
            return Mono.error(new CxtlApiException("Asset class not supported", "ASSET_CLASS_NOT_SUPPORTED", ErrorCode.INVALID_SYMBOL));
        }
        boolean isPerp = assetClass.isPerp();
        return this.getLatestPublicTrades(symbol).map(trades -> trades.stream().filter(t -> t.getSymbol().contains("PERP") == isPerp).collect(Collectors.toList()));
    }

    @NonNull
    private Mono<List<WooTrade>> getLatestPublicTrades(String symbol) {
        String url = "/v1/public/market_trades";
        return this.client.getManyV1(url, new TradeRequest(symbol, 1), WooTradeResponse.class);
    }

    @Override
    public Mono<? extends List<? extends Olhcv>> getOlhcv(Object request) {
        return Mono.empty();
    }

    @Override
    public Mono<? extends Map<AssetClass, List<WooTicker>>> getTickers() {
        return this.getMarkets().map(this::toTickers);
    }

    public Map<AssetClass, List<WooTicker>> toTickers(List<WooMarketInfo> markets) {
        HashMap<AssetClass, List<WooTicker>> map = new HashMap<AssetClass, List<WooTicker>>();
        markets.forEach(m -> WooXRestClient.addTicker(m, map));
        return map;
    }

    private static void addTicker(WooMarketInfo market, Map<AssetClass, List<WooTicker>> tickers) {
        try {
            String[] parts = market.getSymbol().split("_");
            AssetClass ac = AssetClass.valueOf(parts[0].trim().toUpperCase());
            String asset1 = parts[parts.length - 2];
            String asset2 = parts[parts.length - 1];
            tickers.computeIfAbsent(ac, k -> new ArrayList()).add(new WooTicker(market.getSymbol(), asset1, asset2));
        }
        catch (Exception e) {
            LOGGER.error("Invalid market symbol: {}", (Object)market);
        }
    }

    @Override
    public AssetClass[] getSupportedAssetClasses() {
        return new AssetClass[]{AssetClass.SPOT, AssetClass.PERP};
    }

    @Override
    public Exchange getExchange() {
        return Exchange.WOO;
    }

    @Override
    public Mono<List<WooOrder>> getOrders(Credentials credentials, OrderQuery query) {
        return this.client.getMany(credentials, "/v1/orders", query, OrderQueryResponse.class);
    }

    @Override
    public Mono<? extends Order> getOrder(Credentials credentials, OrderQuery orderQuery) {
        if (orderQuery.getClientOrderId() != null) {
            return this.client.getV1(credentials, String.format("/v1/client/order/%s", orderQuery.getClientOrderId()), null, SingleOrderesponse.class);
        }
        if (orderQuery.getOrderId() != null) {
            return this.client.getV1(credentials, String.format("/v1/order/%s", orderQuery.getOrderId()), null, SingleOrderesponse.class);
        }
        return this.getOrders(credentials, orderQuery).map(orders -> orders.isEmpty() ? null : (WooOrder)orders.get(0));
    }

    @Override
    public Mono<OrderAck> placeOrder(Credentials credentials, OrderRequest order) {
        return this.client.postV1(credentials, "/v1/order", order, OrderAck.class);
    }

    @Override
    public Mono<Ack> cancelOrder(Credentials credentials, CancelOrderRequest request) {
        if (request.getOrderId() != null) {
            request.setClientOrderId(null);
            return this.client.deleteV1(credentials, "/v1/order", request, ApiResponse.class).flatMap(r -> Mono.just(new DefaultAck(Long.toString(request.getOrderId()), r.isSuccess() ? AckStatus.SUCCESS : AckStatus.FAIL)));
        }
        return this.client.deleteV1(credentials, "/v1/client/order", request, ApiResponse.class).flatMap(r -> Mono.just(new DefaultAck(Long.toString(request.getClientOrderId()), r.isSuccess() ? AckStatus.SUCCESS : AckStatus.FAIL)));
    }

    public Mono<List<WooMarketInfo>> getMarkets() {
        return this.client.getManyV1("/v1/public/info", null, WooMarketInfoResponse.class);
    }

    public Mono<List<WooOrder>> getOpenOrders(Credentials credentials, OrderQuery query) {
        query.setStatus(OrderStatus.INCOMPLETE);
        return this.getOrders(credentials, query);
    }

    public Mono<AssetInfo> getAssets(Credentials credentials) {
        return this.client.getV3(credentials, "/v3/balances", null, AssetInfoResponse.class);
    }

    private static ErrorCode errorCode(Integer code) {
        if (code == null) {
            return ErrorCode.UNKNOWN_ERROR;
        }
        return switch (code) {
            case -1012, -1008 -> ErrorCode.INSUFFICIENT_BALANCE;
            case -1105, -1103, -1102 -> ErrorCode.BAD_PX;
            case -1104 -> ErrorCode.INVALID_QTY;
            case -1005 -> ErrorCode.UNKNOWN_ORDER;
            default -> ErrorCode.UNKNOWN_ERROR;
        };
    }

    public class RestClientAdapter {
        private final RestClient client;
        private final MetricsLogger metricsLogger;

        public RestClientAdapter(RestClient client, MetricsLogger metricsLogger) {
            this.client = client;
            this.metricsLogger = metricsLogger;
        }

        public <IN, OUT, RESPONSE extends ListV1Response<OUT>> Mono<List<OUT>> getManyV1(String path, IN request, Class<RESPONSE> type) {
            return this.client.get(path, request, type).flatMap(event -> this.handleListV1Response((Event)event, null));
        }

        public <IN, OUT, RESPONSE extends ApiV3Response<OUT>> Mono<OUT> getV3(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.get((builder, json) -> this.v3(credentials, Method.GET, path, builder, json), path, request, type).flatMap(event -> this.handleV3Response((Event)event, request));
        }

        public <IN, OUT> Mono<OUT> getV1(Credentials credentials, String path, IN request, Class<OUT> type) {
            return this.client.get((builder, json) -> this.v1(credentials, builder, json), path, request, type).flatMap(event -> this.handleV1Response((Event)event, request));
        }

        public <IN, OUT, RESPONSE extends ListV1Response<OUT>> Mono<List<OUT>> getMany(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.get((builder, json) -> this.v1(credentials, builder, json), path, request, type).flatMap(event -> this.handleListV1Response((Event)event, request));
        }

        public <IN, RESPONSE extends ApiResponse> Mono<RESPONSE> postV1(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.postAsForm((builder, message) -> this.v1(credentials, builder, message), path, request, type).flatMap(event -> this.handleResponse((Event)event, request));
        }

        public <IN, RESPONSE extends ApiResponse> Mono<RESPONSE> deleteV1(Credentials credentials, String path, IN request, Class<RESPONSE> type) {
            return this.client.deleteAsForm((builder, message) -> this.v1(credentials, builder, message), path, request, type).flatMap(event -> this.handleResponse((Event)event, request));
        }

        private <IN, OUT> Mono<OUT> handleV1Response(Event<OUT> event, IN request) {
            return Mono.just(event.getResponse());
        }

        private <IN, OUT, RESPONSE extends ApiV3Response<OUT>> Mono<OUT> handleV3Response(Event<RESPONSE> event, IN request) {
            return this.handleResponse(event, request, response -> ((ApiV3Response)event.getResponse()).getData());
        }

        private <IN, OUT, RESPONSE extends ListV1Response<OUT>> Mono<List<OUT>> handleListV1Response(Event<RESPONSE> event, IN request) {
            return this.handleResponse(event, request, ListV1Response::getRows);
        }

        private <IN, RESPONSE extends ApiResponse> Mono<RESPONSE> handleResponse(Event<RESPONSE> event, IN request) {
            return this.handleResponse(event, request, r -> r);
        }

        private <IN, OUT, RESPONSE extends ApiResponse> Mono<OUT> handleResponse(Event<RESPONSE> event, IN request, Function<RESPONSE, OUT> success) {
            ApiResponse response = (ApiResponse)event.getResponse();
            if (!response.isSuccess()) {
                this.metricsLogger.finishedError(event);
                String code = response.getCode() == null ? "UNKNOWN" : Integer.toString(response.getCode());
                return Mono.error(new CxtlApiException(code + "( " + response.getMessage() + " ) :" + request, code, WooXRestClient.errorCode(response.getCode())));
            }
            return Mono.just(success.apply(response)).doFinally(v -> this.metricsLogger.finishedSuccess(event));
        }

        public Request.Builder v1(Credentials credentials, Request.Builder builder, String message) {
            long now = Instant.now().toEpochMilli();
            String sb = (message == null ? "" : message) + "|" + now;
            String signature = HmacUtils.sign(credentials, sb);
            return RestClientAdapter.addHeaders(credentials, builder, signature, now);
        }

        public Request.Builder v3(Credentials credentials, Method method, String path, Request.Builder builder, String message) {
            long now = Instant.now().toEpochMilli();
            String sb = now + method.name() + path + (message == null ? "" : message);
            String signature = HmacUtils.sign(credentials, sb);
            return RestClientAdapter.addHeaders(credentials, builder, signature, now);
        }

        @NonNull
        private static Request.Builder addHeaders(Credentials credentials, Request.Builder builder, String signature, long now) {
            return builder.addHeader("x-api-key", credentials.getApiKey()).addHeader("x-api-signature", signature).addHeader("x-api-timestamp", Long.toString(now)).addHeader("Content-Type", "application/json");
        }
    }
}

