/*
 * Decompiled with CFR 0.152.
 */
package estonlabs.cxtl.exchanges.woox.api.vX.lib;

import estonlabs.cxtl.common.AbstractStreamFactory;
import estonlabs.cxtl.common.EnvironmentType;
import estonlabs.cxtl.common.auth.Credentials;
import estonlabs.cxtl.common.codec.Codec;
import estonlabs.cxtl.common.codec.JacksonCodec;
import estonlabs.cxtl.common.security.HmacUtils;
import estonlabs.cxtl.common.stream.core.WebsocketConnection;
import estonlabs.cxtl.common.stream.managed.ManagedWsSession;
import estonlabs.cxtl.exchanges.a.specification.domain.Exchange;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.stream.AuthenticationRequest;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.stream.Pong;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.stream.WooXInboundContainer;
import estonlabs.cxtl.exchanges.woox.api.vX.domain.stream.WooXOutboundMessage;
import estonlabs.cxtl.exchanges.woox.api.vX.lib.WooXRestClient;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;

public class WooXStreamFactory
extends AbstractStreamFactory<WooXOutboundMessage, WooXInboundContainer, WooXStreamFactory> {
    private static final Codec<Object> CODEC = new JacksonCodec();
    public static final URI PROD = URI.create("wss://wss.woo.org");
    public static final URI TEST_NET = URI.create("wss://wss.staging.woo.org");
    private static final Map<EnvironmentType, List<URI>> ENVIRONMENTS = Map.of(EnvironmentType.PROD, List.of(PROD), EnvironmentType.TEST_NET, List.of(TEST_NET));
    private WooXRestClient client;
    private final URI baseUri;

    public WooXStreamFactory(URI baseUri) {
        super(Exchange.WOO, CODEC, WooXInboundContainer.class);
        this.pong(Pong::new);
        this.baseUri = baseUri;
    }

    public WooXStreamFactory() {
        this(PROD);
    }

    public static WooXStreamFactory create(URI uri) {
        return new WooXStreamFactory(uri);
    }

    public static WooXStreamFactory prod() {
        return new WooXStreamFactory();
    }

    @NonNull
    public WooXStreamFactory restClient(WooXRestClient client) {
        this.client = client;
        return this.me();
    }

    protected ManagedWsSession<WooXOutboundMessage, WooXInboundContainer> createPrivateSession(@NonNull String id, @NonNull Credentials credentials) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        ManagedWsSession<WooXOutboundMessage, WooXInboundContainer> session = super.createSession(id, null);
        session.enableLogin(() -> this.loginRequest(credentials));
        return session;
    }

    @NonNull
    private WooXOutboundMessage loginRequest(Credentials credentials) {
        long ts = System.currentTimeMillis();
        String sign = HmacUtils.sign(credentials, "|" + ts);
        AuthenticationRequest.Params params = new AuthenticationRequest.Params(credentials.getApiKey(), sign, ts);
        return new AuthenticationRequest(params);
    }

    public WebsocketConnection<WooXOutboundMessage, WooXInboundContainer> newPublicWebsocket(@NonNull Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        String uri = String.format("%s/ws/stream/%s", this.baseUri.toString(), this.getApplicationId(credentials));
        return super.newPublicWebsocket(URI.create(uri), null);
    }

    public WebsocketConnection<WooXOutboundMessage, WooXInboundContainer> newPublicWebsocket(@NonNull String applicationId) {
        if (applicationId == null) {
            throw new NullPointerException("applicationId is marked non-null but is null");
        }
        String uri = String.format("%s/ws/stream/%s", this.baseUri.toString(), applicationId);
        return super.newPublicWebsocket(URI.create(uri), null);
    }

    public WebsocketConnection<WooXOutboundMessage, WooXInboundContainer> newPrivateWebsocket(@NonNull Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        String url = String.format("%s/v2/ws/private/stream/%s", this.baseUri, this.getApplicationId(credentials));
        return this.newPrivateWebsocket(URI.create(url), null, this.httpProxy, session -> {
            session.enableLogin(() -> this.loginRequest(credentials));
            return session;
        });
    }

    private String getApplicationId(@NonNull Credentials credentials) {
        if (credentials == null) {
            throw new NullPointerException("credentials is marked non-null but is null");
        }
        if (this.client == null) {
            throw new IllegalStateException("You need to explicitly set a set WooXRestClient to lookup the applicationId");
        }
        return Objects.requireNonNull(this.client.getAssets(credentials).block()).getApplicationId();
    }

    @Override
    protected WooXStreamFactory me() {
        return this;
    }
}

