/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtVisitor;
import io.jsonwebtoken.impl.DefaultProtectedJwt;
import io.jsonwebtoken.io.Decoders;

public class DefaultJws<P>
extends DefaultProtectedJwt<JwsHeader, P>
implements Jws<P> {
    private static final String DIGEST_NAME = "signature";
    private final String signature;

    public DefaultJws(JwsHeader header, P payload, String signature) {
        super(header, payload, Decoders.BASE64URL.decode(signature), DIGEST_NAME);
        this.signature = signature;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }

    @Override
    public <T> T accept(JwtVisitor<T> v) {
        return v.visit(this);
    }
}

