/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Header;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.DefaultHeader;
import io.jsonwebtoken.impl.DefaultJweHeader;
import io.jsonwebtoken.impl.DefaultJweHeaderBuilder;
import io.jsonwebtoken.impl.DefaultJweHeaderMutator;
import io.jsonwebtoken.impl.DefaultJwsHeader;
import io.jsonwebtoken.impl.DefaultProtectedHeader;
import io.jsonwebtoken.impl.ParameterMap;
import io.jsonwebtoken.lang.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultJwtHeaderBuilder
extends DefaultJweHeaderBuilder<Jwts.HeaderBuilder>
implements Jwts.HeaderBuilder {
    public DefaultJwtHeaderBuilder() {
    }

    public DefaultJwtHeaderBuilder(DefaultJweHeaderMutator<?> src) {
        super(src);
    }

    private static ParameterMap sanitizeCrit(ParameterMap m, boolean protectedHeader) {
        Set<String> crit = m.get(DefaultProtectedHeader.CRIT);
        if (crit == null) {
            return m;
        }
        m = new ParameterMap(DefaultJweHeader.PARAMS, m, true);
        m.remove(DefaultProtectedHeader.CRIT.getId());
        if (!protectedHeader) {
            return m;
        }
        LinkedHashSet<String> newCrit = new LinkedHashSet<String>(crit);
        for (String val2 : crit) {
            if (!DefaultJweHeader.PARAMS.containsKey(val2) && m.containsKey(val2)) continue;
            newCrit.remove(val2);
        }
        if (!Collections.isEmpty(newCrit)) {
            m.put(DefaultProtectedHeader.CRIT, (Object)newCrit);
        }
        return m;
    }

    @Override
    public Header build() {
        this.x509.apply();
        ParameterMap m = (ParameterMap)this.DELEGATE;
        if (DefaultJweHeader.isCandidate(m)) {
            return new DefaultJweHeader(DefaultJwtHeaderBuilder.sanitizeCrit(m, true));
        }
        if (DefaultProtectedHeader.isCandidate(m)) {
            return new DefaultJwsHeader(DefaultJwtHeaderBuilder.sanitizeCrit(m, true));
        }
        return new DefaultHeader(DefaultJwtHeaderBuilder.sanitizeCrit(m, false));
    }
}

