/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.security;

import io.jsonwebtoken.impl.io.Streams;
import io.jsonwebtoken.impl.lang.Nameable;
import io.jsonwebtoken.impl.lang.Parameter;
import io.jsonwebtoken.impl.lang.ParameterReadable;
import io.jsonwebtoken.impl.lang.Parameters;
import io.jsonwebtoken.impl.security.DefaultJwkThumbprint;
import io.jsonwebtoken.impl.security.DefaultRequest;
import io.jsonwebtoken.impl.security.JwkContext;
import io.jsonwebtoken.impl.security.KeyOperationConverter;
import io.jsonwebtoken.lang.Arrays;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.lang.Supplier;
import io.jsonwebtoken.security.HashAlgorithm;
import io.jsonwebtoken.security.Jwk;
import io.jsonwebtoken.security.JwkThumbprint;
import io.jsonwebtoken.security.Jwks;
import io.jsonwebtoken.security.KeyOperation;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractJwk<K extends Key>
implements Jwk<K>,
ParameterReadable,
Nameable {
    static final Parameter<String> ALG = Parameters.string("alg", "Algorithm");
    public static final Parameter<String> KID = Parameters.string("kid", "Key ID");
    static final Parameter<Set<KeyOperation>> KEY_OPS = (Parameter)Parameters.builder(KeyOperation.class).setConverter(KeyOperationConverter.DEFAULT).set().setId("key_ops").setName("Key Operations").build();
    static final Parameter<String> KTY = Parameters.string("kty", "Key Type");
    static final Set<Parameter<?>> PARAMS = Collections.setOf(ALG, KID, KEY_OPS, KTY);
    public static final String IMMUTABLE_MSG = "JWKs are immutable and may not be modified.";
    protected final JwkContext<K> context;
    private final List<Parameter<?>> THUMBPRINT_PARAMS;
    private final int hashCode;

    AbstractJwk(JwkContext<K> ctx, List<Parameter<?>> thumbprintParams) {
        this.context = Assert.notNull(ctx, "JwkContext cannot be null.");
        Assert.isTrue(!ctx.isEmpty(), "JwkContext cannot be empty.");
        Assert.hasText(ctx.getType(), "JwkContext type cannot be null or empty.");
        Assert.notNull(ctx.getKey(), "JwkContext key cannot be null.");
        this.THUMBPRINT_PARAMS = Assert.notEmpty(thumbprintParams, "JWK Thumbprint parameters cannot be null or empty.");
        HashAlgorithm idThumbprintAlg = ctx.getIdThumbprintAlgorithm();
        if (!Strings.hasText(this.getId()) && idThumbprintAlg != null) {
            JwkThumbprint thumbprint = this.thumbprint(idThumbprintAlg);
            String kid = thumbprint.toString();
            ctx.setId(kid);
        }
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        ArrayList<String> list = new ArrayList<String>(this.THUMBPRINT_PARAMS.size() + 1);
        Key key = (Key)Assert.notNull(this.toKey(), "JWK toKey() value cannot be null.");
        if (key instanceof PublicKey) {
            list.add("Public");
        } else if (key instanceof PrivateKey) {
            list.add("Private");
        }
        for (Parameter<?> param : this.THUMBPRINT_PARAMS) {
            Object val2 = Assert.notNull(this.get(param), "computeHashCode: Parameter idiomatic value cannot be null.");
            list.add((String)val2);
        }
        return Objects.nullSafeHashCode(list.toArray());
    }

    private String getRequiredThumbprintValue(Parameter<?> param) {
        Object value = this.get(param.getId());
        if (value instanceof Supplier) {
            value = ((Supplier)value).get();
        }
        return Assert.isInstanceOf(String.class, value, "Parameter canonical value is not a String.");
    }

    private String toThumbprintJson() {
        StringBuilder sb = new StringBuilder().append('{');
        Iterator<Parameter<?>> i = this.THUMBPRINT_PARAMS.iterator();
        while (i.hasNext()) {
            Parameter<?> param = i.next();
            String value = this.getRequiredThumbprintValue(param);
            sb.append('\"').append(param.getId()).append("\":\"").append(value).append('\"');
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public JwkThumbprint thumbprint() {
        return this.thumbprint(Jwks.HASH.SHA256);
    }

    @Override
    public JwkThumbprint thumbprint(HashAlgorithm alg) {
        String json = this.toThumbprintJson();
        Assert.hasText(json, "Canonical JWK Thumbprint JSON cannot be null or empty.");
        byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
        InputStream in = Streams.of(bytes);
        byte[] digest = alg.digest(new DefaultRequest<InputStream>(in, this.context.getProvider(), this.context.getRandom()));
        return new DefaultJwkThumbprint(digest, alg);
    }

    @Override
    public String getType() {
        return this.context.getType();
    }

    @Override
    public String getName() {
        return this.context.getName();
    }

    @Override
    public Set<KeyOperation> getOperations() {
        return Collections.immutable(this.context.getOperations());
    }

    @Override
    public String getAlgorithm() {
        return this.context.getAlgorithm();
    }

    @Override
    public String getId() {
        return this.context.getId();
    }

    @Override
    public K toKey() {
        return this.context.getKey();
    }

    @Override
    public int size() {
        return this.context.size();
    }

    @Override
    public boolean isEmpty() {
        return this.context.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.context.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.context.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        Object val2 = this.context.get(key);
        if (val2 instanceof Map) {
            return Collections.immutable((Map)val2);
        }
        if (val2 instanceof Collection) {
            return Collections.immutable((Collection)val2);
        }
        if (Objects.isArray(val2)) {
            return Arrays.copy(val2);
        }
        return val2;
    }

    @Override
    public <T> T get(Parameter<T> param) {
        return this.context.get(param);
    }

    @Override
    public Set<String> keySet() {
        return Collections.immutable(this.context.keySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.immutable(this.context.values());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.immutable(this.context.entrySet());
    }

    private static Object immutable() {
        throw new UnsupportedOperationException(IMMUTABLE_MSG);
    }

    @Override
    public Object put(String s, Object o) {
        return AbstractJwk.immutable();
    }

    @Override
    public Object remove(Object o) {
        return AbstractJwk.immutable();
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        AbstractJwk.immutable();
    }

    @Override
    public void clear() {
        AbstractJwk.immutable();
    }

    public String toString() {
        return this.context.toString();
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Jwk) {
            Jwk other = (Jwk)obj;
            return this.getType().equals(other.getType()) && this.equals(other);
        }
        return false;
    }

    protected abstract boolean equals(Jwk<?> var1);
}

