/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.threadpool;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.ProbeNotifier;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class SyncThreadPool
extends AbstractThreadPool {
    private final Queue<Runnable> workQueue;
    protected int maxQueuedTasks = -1;
    private int currentPoolSize;
    private int activeThreadsCount;

    public SyncThreadPool(ThreadPoolConfig config) {
        super(config);
        if (config.getKeepAliveTime(TimeUnit.MILLISECONDS) < 0L) {
            throw new IllegalArgumentException("keepAliveTime < 0");
        }
        this.workQueue = config.getQueue() != null ? config.getQueue() : config.setQueue(new LinkedList<Runnable>()).getQueue();
        this.maxQueuedTasks = config.getQueueLimit();
        int corePoolSize = config.getCorePoolSize();
        while (this.currentPoolSize < corePoolSize) {
            this.startWorker(new SyncThreadWorker(true));
        }
        ProbeNotifier.notifyThreadPoolStarted(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException("Runnable task is null");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.running) {
                throw new RejectedExecutionException("ThreadPool is not running");
            }
            int workQueueSize = this.workQueue.size() + 1;
            if ((this.maxQueuedTasks < 0 || workQueueSize <= this.maxQueuedTasks) && this.workQueue.offer(task)) {
                this.onTaskQueued(task);
            } else {
                this.onTaskQueueOverflow();
                assert (false);
            }
            int idleThreadsNumber = this.currentPoolSize - this.activeThreadsCount;
            if (idleThreadsNumber >= workQueueSize) {
                this.stateLock.notify();
                return;
            }
            if (this.currentPoolSize < this.config.getMaxPoolSize()) {
                boolean isCore = this.currentPoolSize < this.config.getCorePoolSize();
                this.startWorker(new SyncThreadWorker(isCore));
                if (this.currentPoolSize == this.config.getMaxPoolSize()) {
                    this.onMaxNumberOfThreadsReached();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startWorker(AbstractThreadPool.Worker worker) {
        Object object = this.stateLock;
        synchronized (object) {
            super.startWorker(worker);
            ++this.activeThreadsCount;
            ++this.currentPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onWorkerExit(AbstractThreadPool.Worker worker) {
        super.onWorkerExit(worker);
        Object object = this.stateLock;
        synchronized (object) {
            --this.currentPoolSize;
            --this.activeThreadsCount;
        }
    }

    @Override
    protected void poisonAll() {
        int size = this.currentPoolSize;
        Queue<Runnable> q = this.getQueue();
        while (size-- > 0) {
            q.offer(poison);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.stateLock;
        synchronized (object) {
            return super.toString() + ", max-queue-size=" + this.maxQueuedTasks;
        }
    }

    protected class SyncThreadWorker
    extends AbstractThreadPool.Worker {
        private final boolean core;

        public SyncThreadWorker(boolean core) {
            this.core = core;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Runnable getTask() throws InterruptedException {
            Object object = SyncThreadPool.this.stateLock;
            synchronized (object) {
                --SyncThreadPool.this.activeThreadsCount;
                try {
                    if (!SyncThreadPool.this.running || !this.core && SyncThreadPool.this.currentPoolSize > SyncThreadPool.this.config.getMaxPoolSize()) {
                        Runnable runnable2 = null;
                        return runnable2;
                    }
                    Runnable r = SyncThreadPool.this.workQueue.poll();
                    if (r != null) {
                        Runnable runnable3 = r;
                        return runnable3;
                    }
                    long keepAliveMillis = SyncThreadPool.this.config.getKeepAliveTime(TimeUnit.MILLISECONDS);
                    boolean hasKeepAlive = !this.core && keepAliveMillis >= 0L;
                    long endTime = -1L;
                    if (hasKeepAlive) {
                        endTime = System.currentTimeMillis() + keepAliveMillis;
                    }
                    do {
                        if (!hasKeepAlive) {
                            SyncThreadPool.this.stateLock.wait();
                        } else {
                            SyncThreadPool.this.stateLock.wait(keepAliveMillis);
                        }
                        r = SyncThreadPool.this.workQueue.poll();
                        if (r != null) {
                            Runnable runnable4 = r;
                            return runnable4;
                        }
                        if (SyncThreadPool.this.running) continue;
                        Runnable runnable5 = null;
                        return runnable5;
                    } while (!hasKeepAlive || (keepAliveMillis = endTime - System.currentTimeMillis()) >= 20L);
                    Runnable runnable6 = null;
                    return runnable6;
                }
                finally {
                    ++SyncThreadPool.this.activeThreadsCount;
                }
            }
        }
    }
}

