/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.core.buffer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import org.msgpack.core.Preconditions;
import org.msgpack.core.buffer.ChannelBufferInput;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferInput;

public class InputStreamBufferInput
implements MessageBufferInput {
    private InputStream in;
    private final byte[] buffer;

    public static MessageBufferInput newBufferInput(InputStream inputStream2) {
        FileChannel fileChannel;
        Preconditions.checkNotNull(inputStream2, "InputStream is null");
        if (inputStream2 instanceof FileInputStream && (fileChannel = ((FileInputStream)inputStream2).getChannel()) != null) {
            return new ChannelBufferInput(fileChannel);
        }
        return new InputStreamBufferInput(inputStream2);
    }

    public InputStreamBufferInput(InputStream inputStream2) {
        this(inputStream2, 8192);
    }

    public InputStreamBufferInput(InputStream inputStream2, int n) {
        this.in = Preconditions.checkNotNull(inputStream2, "input is null");
        this.buffer = new byte[n];
    }

    public InputStream reset(InputStream inputStream2) throws IOException {
        InputStream inputStream3 = this.in;
        this.in = inputStream2;
        return inputStream3;
    }

    @Override
    public MessageBuffer next() throws IOException {
        int n = this.in.read(this.buffer);
        if (n == -1) {
            return null;
        }
        return MessageBuffer.wrap(this.buffer, 0, n);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

