/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi.datatypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.datatypes.AbiTypes;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.Type;

public abstract class StaticArray<T extends Type>
extends Array<T> {
    public static final int MAX_SIZE_OF_STATIC_ARRAY = 32;

    @Deprecated
    @SafeVarargs
    public StaticArray(T ... values2) {
        this(values2.length, (Type[])values2);
    }

    @Deprecated
    @SafeVarargs
    public StaticArray(int expectedSize, T ... values2) {
        this(expectedSize, Arrays.asList(values2));
    }

    @Deprecated
    public StaticArray(List<T> values2) {
        this(values2.size(), values2);
    }

    @Deprecated
    public StaticArray(int expectedSize, List<T> values2) {
        super(AbiTypes.getType(((Type)values2.get(0)).getTypeAsString()), values2);
        this.checkValid(expectedSize);
    }

    @SafeVarargs
    public StaticArray(Class<T> type, T ... values2) {
        this(type, Arrays.asList(values2));
    }

    @SafeVarargs
    public StaticArray(Class<T> type, int expectedSize, T ... values2) {
        this(type, expectedSize, Arrays.asList(values2));
    }

    public StaticArray(Class<T> type, List<T> values2) {
        this(type, values2 == null ? 0 : values2.size(), values2);
    }

    public StaticArray(Class<T> type, int expectedSize, List<T> values2) {
        super(type, values2);
        this.checkValid(expectedSize);
    }

    @Override
    public List<T> getValue() {
        return Collections.unmodifiableList(this.value);
    }

    @Override
    public String getTypeAsString() {
        return AbiTypes.getTypeAString(this.getComponentType()) + "[" + this.value.size() + "]";
    }

    private void checkValid(int expectedSize) {
        if (this.value.size() > 32) {
            throw new UnsupportedOperationException("Static arrays with a length greater than 32 are not supported.");
        }
        if (this.value.size() != expectedSize) {
            throw new UnsupportedOperationException("Expected array of type [" + this.getClass().getSimpleName() + "] to have [" + expectedSize + "] elements.");
        }
    }
}

