/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.smsuapi.dao.beans;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import org.esupportail.smsuapi.dao.beans.Application;
import org.esupportail.smsuapi.dao.beans.Sms;

public class Account
implements Serializable {
    public static final String REF = "Account";
    public static final String PROP_QUOTA = "Quota";
    public static final String PROP_CONSUMED_SMS = "ConsumedSms";
    public static final String PROP_LABEL = "Label";
    public static final String PROP_ID = "Id";
    private static final long serialVersionUID = -1278768065587081098L;
    private Integer id;
    private String label;
    private Long quota;
    private Long consumedSms;
    private Set<Sms> sms;
    private Set<Application> applications;

    public Account() {
    }

    public Account(Integer id, String label, Long consumedSms) {
        this.setId(id);
        this.setLabel(label);
        this.setConsumedSms(consumedSms);
    }

    public static Account createDefault(Application app, String label) {
        Account acc = new Account();
        acc.addToApplications(app);
        acc.setLabel(label);
        acc.setQuota(0L);
        acc.setConsumedSms(0L);
        return acc;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Long getQuota() {
        return this.quota;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public Long getConsumedSms() {
        return this.consumedSms;
    }

    public boolean checkQuota(int nbToSend) {
        long nbAvailable = this.getQuota() - this.getConsumedSms();
        return nbAvailable >= (long)nbToSend;
    }

    public void setConsumedSms(Long consumedSms) {
        this.consumedSms = consumedSms;
    }

    public Set<Sms> getSms() {
        return this.sms;
    }

    public void setSms(Set<Sms> sms) {
        this.sms = sms;
    }

    public void addToSms(Sms sms) {
        if (null == this.getSms()) {
            this.setSms(new TreeSet<Sms>());
        }
        this.getSms().add(sms);
    }

    public Set<Application> getApplications() {
        return this.applications;
    }

    public void setApplications(Set<Application> applications) {
        this.applications = applications;
    }

    public void addToApplications(Application application) {
        if (null == this.getApplications()) {
            this.setApplications(new TreeSet<Application>());
        }
        this.getApplications().add(application);
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account account = (Account)obj;
        if (null == this.getId() || null == account.getId()) {
            return false;
        }
        return this.getId().equals(account.getId());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "Account#" + this.hashCode() + "[id=[" + this.id + "], label=[" + this.label + "], quota=[" + this.quota + "], number of consumed sms =[" + this.consumedSms + "]]";
    }
}

