/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.smsuapi.dao.beans;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import org.esupportail.smsuapi.dao.beans.Account;
import org.esupportail.smsuapi.dao.beans.Blacklist;
import org.esupportail.smsuapi.dao.beans.Institution;
import org.esupportail.smsuapi.dao.beans.Sms;

public class Application
implements Serializable,
Comparable<Application> {
    public static final String REF = "Application";
    public static final String PROP_QUOTA = "Quota";
    public static final String PROP_INS = "Ins";
    public static final String PROP_ACC = "Acc";
    public static final String PROP_PASSWORD = "Password";
    public static final String PROP_CONSUMED_SMS = "ConsumedSms";
    public static final String PROP_NAME = "Name";
    public static final String PROP_ID = "Id";
    private static final long serialVersionUID = 7265005139032030997L;
    private Integer id;
    private String name;
    private String password;
    private Long quota;
    private Long consumedSms;
    private Account acc;
    private Institution ins;
    private Set<Sms> sms;
    private Set<Blacklist> blacklists;
    private String PASSWORD_PREFIX_IN_CERTIFCATE = "PASSWORD:";

    public Application() {
    }

    public Application(Integer id, Account acc, Institution ins, String name, Long quota, Long consumedSms) {
        this.setId(id);
        this.setAcc(acc);
        this.setIns(ins);
        this.setName(name);
        this.setQuota(quota);
        this.setConsumedSms(consumedSms);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getPasswordWasCertificate() {
        return this.password.getBytes();
    }

    public void setPasswordWasCertificate(byte[] passwordWasCertificate) {
        String s = new String(passwordWasCertificate);
        s = this.removePrefix(s, this.PASSWORD_PREFIX_IN_CERTIFCATE);
        this.setPassword(s);
    }

    private String removePrefix(String s, String prefix) {
        return s.startsWith(prefix) ? s.substring(prefix.length()) : s;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getQuota() {
        return this.quota;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public Long getConsumedSms() {
        return this.consumedSms;
    }

    public void setConsumedSms(Long consumedSms) {
        this.consumedSms = consumedSms;
    }

    public boolean checkQuota(int nbToSend) {
        long nbAvailable = this.getQuota() - this.getConsumedSms();
        return nbAvailable >= (long)nbToSend;
    }

    public Account getAcc() {
        return this.acc;
    }

    public void setAcc(Account acc) {
        this.acc = acc;
    }

    public Institution getIns() {
        return this.ins;
    }

    public void setIns(Institution ins) {
        this.ins = ins;
    }

    public Set<Sms> getSms() {
        return this.sms;
    }

    public void setSms(Set<Sms> sms) {
        this.sms = sms;
    }

    public void addToSms(Sms sms) {
        if (null == this.getSms()) {
            this.setSms(new TreeSet<Sms>());
        }
        this.getSms().add(sms);
    }

    public Set<Blacklist> getBlacklists() {
        return this.blacklists;
    }

    public void setBlacklists(Set<Blacklist> blacklists) {
        this.blacklists = blacklists;
    }

    public void addToBlacklists(Blacklist blacklist) {
        if (null == this.getBlacklists()) {
            this.setBlacklists(new TreeSet<Blacklist>());
        }
        this.getBlacklists().add(blacklist);
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application application = (Application)obj;
        if (null == this.getId() || null == application.getId()) {
            return false;
        }
        return this.getId().equals(application.getId());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "Application#" + this.hashCode() + "[id=[" + this.id + "], name=[" + this.name + "], quota=[" + this.quota + "], number of consumed sms=[" + this.consumedSms + "]]";
    }

    @Override
    public int compareTo(Application app) {
        return this.getName().compareTo(app.getName());
    }
}

