/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.smsuapi.services.client;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.esupportail.smsuapi.exceptions.InsufficientQuotaException;
import org.esupportail.smsuapi.exceptions.InvalidParameterException;
import org.esupportail.smsuapi.exceptions.UnknownMessageIdException;
import org.esupportail.smsuapi.services.client.SmsuapiWS;
import org.esupportail.smsuapi.utils.HttpException;
import org.esupportail.smsuapi.utils.HttpUtils;
import org.esupportail.ws.remote.beans.TrackInfos;
import org.springframework.beans.factory.annotation.Required;

public class HttpRequestSmsuapiWS {
    private final Logger logger = Logger.getLogger(this.getClass());
    private String username;
    private String password;
    private String url;

    public HttpRequestSmsuapiWS() {
    }

    public HttpRequestSmsuapiWS(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public Integer sendSms(Integer id, String recipient, String message) throws HttpException, InsufficientQuotaException {
        return this.sendSms(id, recipient, message, null);
    }

    public Integer sendSms(Integer id, String recipient, String message, String account) throws HttpException, InsufficientQuotaException {
        return this.sendSms(id, recipient, message, account, null);
    }

    public Integer sendSms(Integer id, String recipient, String message, String account, Integer senderId) throws HttpException, InsufficientQuotaException {
        return this.sendSms(id, this.singletonListOrEmpty(recipient), message, account, senderId);
    }

    public Integer sendSms(Integer id, List<String> recipients, String message, String account, Integer senderId) throws HttpException, InsufficientQuotaException {
        LinkedList<HttpUtils.Pair> params = new LinkedList<HttpUtils.Pair>();
        for (String recipient : recipients) {
            params.add(new HttpUtils.Pair("phoneNumber", recipient));
        }
        params.add(new HttpUtils.Pair("message", message));
        if (id != null) {
            params.add(new HttpUtils.Pair("id", "" + id));
        }
        if (account != null) {
            params.add(new HttpUtils.Pair("account", account));
        }
        if (senderId != null) {
            params.add(new HttpUtils.Pair("senderId", "" + senderId));
        }
        JsonNode json = this.requestPOST("SendSms", params);
        return this.convertToInteger(json.path("id"));
    }

    public void mayCreateAccountCheckQuotaOk(String account, int nbDest) throws HttpException, InsufficientQuotaException {
        HttpUtils.Pair[] params = new HttpUtils.Pair[]{new HttpUtils.Pair("account", account), new HttpUtils.Pair("nbDest", "" + nbDest)};
        this.request("MayCreateAccountCheckQuotaOk", params);
    }

    public List<String> messageStatus(List<HttpUtils.Pair> params) throws HttpException, UnknownMessageIdException {
        return this.convertToStringList(this.request("MessageStatus", params));
    }

    public TrackInfos messageInfos(Integer msgId) throws HttpException, UnknownMessageIdException {
        HttpUtils.Pair[] params = new HttpUtils.Pair[]{new HttpUtils.Pair("id", "" + msgId)};
        try {
            JsonNode json = this.request("MessageInfos", params);
            return (TrackInfos)new ObjectMapper().readValue(json, TrackInfos.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String testConnexion() throws HttpException {
        HttpUtils.Pair[] params = new HttpUtils.Pair[]{};
        JsonNode json = this.request("TestConnexion", params);
        return json.getTextValue();
    }

    public Set<String> getListPhoneNumbersInBlackList() throws HttpException {
        HttpUtils.Pair[] params = new HttpUtils.Pair[]{};
        JsonNode json = this.request("ListPhoneNumbersInBlackList", params);
        return this.convertToStringSet(json);
    }

    public boolean isPhoneNumberInBlackList(String phoneNumber) throws HttpException {
        HttpUtils.Pair[] params = new HttpUtils.Pair[]{new HttpUtils.Pair("phoneNumber", phoneNumber)};
        JsonNode json = this.request("IsBlacklisted", params);
        return json.getBooleanValue();
    }

    private Integer convertToInteger(JsonNode json) {
        return json.isInt() ? Integer.valueOf(json.getIntValue()) : null;
    }

    private List<String> convertToStringList(JsonNode json) {
        LinkedList<String> l = new LinkedList<String>();
        Iterator it = json.getElements();
        while (it.hasNext()) {
            l.add(((JsonNode)it.next()).getTextValue());
        }
        return l;
    }

    private Set<String> convertToStringSet(JsonNode json) {
        HashSet<String> l = new HashSet<String>();
        Iterator it = json.getElements();
        while (it.hasNext()) {
            l.add(((JsonNode)it.next()).getTextValue());
        }
        return l;
    }

    private JsonNode requestPOST(String action, List<HttpUtils.Pair> params) throws HttpException {
        String json;
        String cooked_url = HttpUtils.cook_url(this.url, "action", action);
        try {
            json = HttpUtils.requestPOST(HttpUtils.basicAuth(HttpUtils.openConnection(cooked_url), this.username, this.password), params);
        }
        catch (HttpException.WithStatusCode e) {
            throw this.remapException(e);
        }
        return this.parseResponse(json);
    }

    private JsonNode request(String action, List<HttpUtils.Pair> params) throws HttpException {
        String cooked_url = HttpUtils.cook_url(this.url, "action", action, params);
        return this.request(cooked_url);
    }

    private JsonNode request(String action, HttpUtils.Pair[] params) throws HttpException {
        String cooked_url = HttpUtils.cook_url(this.url, "action", action, params);
        return this.request(cooked_url);
    }

    private JsonNode request(String cooked_url) throws HttpException {
        String json;
        this.logger.warn((Object)("asking " + cooked_url));
        try {
            json = HttpUtils.requestGET(HttpUtils.basicAuth(HttpUtils.openConnection(cooked_url), this.username, this.password));
        }
        catch (HttpException.WithStatusCode e) {
            throw this.remapException(e);
        }
        return this.parseResponse(json);
    }

    private JsonNode parseResponse(String json) throws HttpException {
        this.logger.warn((Object)("response " + json));
        try {
            return new ObjectMapper().readTree(json);
        }
        catch (IOException e) {
            throw new SmsuapiWS.BadJsonException(json, e);
        }
    }

    private HttpException remapException(HttpException.WithStatusCode e) {
        String error;
        JsonNode jsonErr;
        if (e.getStatusCode() == 404) {
            return new SmsuapiWS.UnreachableException(e);
        }
        if (e.getStatusCode() == 401) {
            return new SmsuapiWS.AuthenticationFailedException(e);
        }
        if (e.getStatusCode() == 400 && (jsonErr = HttpUtils.json_decode(e.getErrorMessage())) != null && (error = jsonErr.path("error").getTextValue()) != null) {
            if (error.equals("UnknownMessageIdException")) {
                Unchecked.throw_(new UnknownMessageIdException());
            } else {
                if (error.equals("InvalidParameterException")) {
                    throw new InvalidParameterException(jsonErr.path("message").getTextValue());
                }
                if (error.equals("InsufficientQuotaException")) {
                    Unchecked.throw_(new InsufficientQuotaException(jsonErr.path("message").getTextValue()));
                }
            }
        }
        return e;
    }

    private <A> LinkedList<A> singletonListOrEmpty(A e) {
        LinkedList<A> l = new LinkedList<A>();
        if (e != null) {
            l.add(e);
        }
        return l;
    }

    @Required
    public void setUsername(String username) {
        this.username = username;
    }

    @Required
    public void setPassword(String password) {
        this.password = password;
    }

    @Required
    public void setUrl(String url) {
        this.url = url;
    }

    static class Unchecked {
        Unchecked() {
        }

        public static void throw_(Exception e) {
            Unchecked.throwAnyImpl(e);
        }

        private static <T extends Exception> void throwAnyImpl(Exception e) throws T {
            throw e;
        }
    }
}

