/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.smsuapi.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class HttpException
extends Exception {
    public HttpException() {
    }

    public HttpException(Throwable throwable) {
        super(throwable);
    }

    public static class WithStatusCode
    extends HttpException {
        private int statusCode = -1;
        private String messageLine;
        private String errorMessage;
        private URL url;

        public WithStatusCode(HttpURLConnection conn) {
            this.url = conn.getURL();
            try {
                this.statusCode = conn.getResponseCode();
                this.messageLine = conn.getResponseMessage();
                this.errorMessage = IOUtils.toString((InputStream)conn.getErrorStream(), (String)"UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException("internal error: HttpException could not be created", e);
            }
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getMessageLine() {
            return this.messageLine;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public URL getUrl() {
            return this.url;
        }

        @Override
        public String toString() {
            return "HttpException: " + this.statusCode + " " + this.messageLine + "\n" + this.errorMessage;
        }
    }

    public static class BadRedirect
    extends HttpException {
        private String err;

        public BadRedirect(HttpURLConnection conn) {
            this.err = "badly configured url, smsuapi sent a Redirect to " + conn.getHeaderField("Location") + " instead of " + conn.getURL();
        }

        @Override
        public String toString() {
            return "HttpException: " + this.err;
        }
    }

    public static class Unreachable
    extends HttpException {
        public Unreachable(Exception e) {
            super(e);
        }
    }
}

