/*
 * Decompiled with CFR 0.152.
 */
package org.esupportail.smsuapi.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.esupportail.smsuapi.utils.HttpException;

public class HttpUtils {
    private static final Logger logger = Logger.getLogger(HttpUtils.class);
    private static int defaultConnectTimeout = 10;

    public static HttpURLConnection basicAuth(HttpURLConnection uc, String username, String password) {
        String userpass = username + ":" + password;
        String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes());
        uc.setRequestProperty("Authorization", basicAuth);
        return uc;
    }

    public static HttpURLConnection openConnection(String request) throws HttpException {
        return HttpUtils.openConnection(request, defaultConnectTimeout);
    }

    public static HttpURLConnection openConnection(String request, int timeout) throws HttpException {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(request).openConnection();
            conn.setConnectTimeout(timeout * 1000);
            return conn;
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    public static String requestGET(HttpURLConnection conn) throws HttpException {
        return HttpUtils.requestRaw(conn);
    }

    public static String requestPOST(HttpURLConnection conn, List<Pair> params) throws HttpException {
        conn.setInstanceFollowRedirects(false);
        conn.setDoOutput(true);
        try {
            IOUtils.write((String)HttpUtils.formatParams(params), (OutputStream)conn.getOutputStream());
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        return HttpUtils.requestRaw(conn);
    }

    private static String requestRaw(HttpURLConnection conn) throws HttpException {
        try {
            conn.connect();
            int code = conn.getResponseCode();
            if (code >= 300 && code < 400 && code != 304) {
                HttpException.BadRedirect e = new HttpException.BadRedirect(conn);
                logger.error((Object)e);
                throw e;
            }
            if (code >= 400) {
                logger.error((Object)(conn.getURL() + " error: " + conn.getResponseMessage()));
                throw new HttpException.WithStatusCode(conn);
            }
        }
        catch (ConnectException | SocketTimeoutException | UnknownHostException | SSLException e) {
            throw new HttpException.Unreachable(e);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        InputStream inputStream = null;
        try {
            String resp;
            inputStream = conn.getInputStream();
            String string = resp = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String cook_url(String url, String name1, String val1) {
        return url + "?" + HttpUtils.urlencode(name1) + "=" + HttpUtils.urlencode(val1);
    }

    public static String cook_url(String url, String name1, String val1, List<Pair> params) {
        return url + "?" + HttpUtils.urlencode(name1) + "=" + HttpUtils.urlencode(val1) + "&" + HttpUtils.formatParams(params);
    }

    public static String cook_url(String url, String name1, String val1, Pair[] params) {
        return url + "?" + HttpUtils.urlencode(name1) + "=" + HttpUtils.urlencode(val1) + "&" + HttpUtils.formatParams(params);
    }

    private static String formatParams(Pair[] params) {
        StringBuffer requestParams = null;
        for (Pair param : params) {
            if (requestParams == null) {
                requestParams = new StringBuffer();
            } else {
                requestParams.append("&");
            }
            requestParams.append(HttpUtils.urlencode(param.a)).append("=").append(HttpUtils.urlencode(param.b));
        }
        return requestParams == null ? null : requestParams.toString();
    }

    private static String formatParams(List<Pair> params) {
        StringBuffer requestParams = null;
        for (Pair param : params) {
            if (requestParams == null) {
                requestParams = new StringBuffer();
            } else {
                requestParams.append("&");
            }
            requestParams.append(HttpUtils.urlencode(param.a)).append("=").append(HttpUtils.urlencode(param.b));
        }
        return requestParams == null ? null : requestParams.toString();
    }

    public static String urlencode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("urlencode failed on '" + s + "'");
        }
    }

    public static JsonNode json_decode(String s) {
        try {
            return new ObjectMapper().readTree(s);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class Pair {
        String a;
        String b;

        public Pair(String a, String b) {
            this.a = a;
            this.b = b;
        }
    }
}

