/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexReference;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.RelationshipId;

class CommitContext
implements Closeable {
    final LuceneDataSource dataSource;
    final IndexIdentifier identifier;
    final IndexType indexType;
    final Map<Long, DocumentContext> documents = new HashMap<Long, DocumentContext>();
    final boolean recovery;
    IndexReference searcher;
    IndexWriter writer;

    CommitContext(LuceneDataSource dataSource, IndexIdentifier identifier, IndexType indexType, boolean isRecovery) {
        this.dataSource = dataSource;
        this.identifier = identifier;
        this.indexType = indexType;
        this.recovery = isRecovery;
    }

    void ensureWriterInstantiated() {
        if (this.searcher == null) {
            this.searcher = this.dataSource.getIndexSearcher(this.identifier);
            this.writer = this.searcher.getWriter();
        }
    }

    DocumentContext getDocument(Object entityId, boolean allowCreate) {
        long id = entityId instanceof Long ? (Long)entityId : ((RelationshipId)entityId).id;
        DocumentContext context = this.documents.get(id);
        if (context != null) {
            return context;
        }
        Document document = LuceneDataSource.findDocument(this.indexType, this.searcher.getSearcher(), id);
        if (document != null) {
            context = new DocumentContext(document, true, id);
            this.documents.put(id, context);
        } else if (allowCreate) {
            context = new DocumentContext(IndexType.newDocument(entityId), false, id);
            this.documents.put(id, context);
        }
        return context;
    }

    private void applyDocuments(IndexWriter writer, IndexType type, Map<Long, DocumentContext> documents) throws IOException {
        for (Map.Entry<Long, DocumentContext> entry : documents.entrySet()) {
            DocumentContext context = entry.getValue();
            if (context.exists) {
                if (LuceneDataSource.documentIsEmpty(context.document)) {
                    writer.deleteDocuments(type.idTerm(context.entityId));
                    continue;
                }
                writer.updateDocument(type.idTerm(context.entityId), context.document);
                continue;
            }
            writer.addDocument(context.document);
        }
    }

    @Override
    public void close() throws IOException {
        this.applyDocuments(this.writer, this.indexType, this.documents);
        if (this.writer != null) {
            this.dataSource.invalidateIndexSearcher(this.identifier);
        }
        if (this.searcher != null) {
            this.searcher.close();
        }
    }

    static class DocumentContext {
        final Document document;
        final boolean exists;
        final long entityId;

        DocumentContext(Document document, boolean exists, long entityId) {
            this.document = document;
            this.exists = exists;
            this.entityId = entityId;
        }

        public String toString() {
            return "DocumentContext[document=" + this.document + ", exists=" + this.exists + ", entityId=" + this.entityId + "]";
        }
    }
}

