/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.impl.lucene.ConstantScoreIterator;
import org.neo4j.index.impl.lucene.DocToIdIterator;
import org.neo4j.index.impl.lucene.Hits;
import org.neo4j.index.impl.lucene.HitsIterator;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.RelationshipId;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.kernel.api.LegacyIndexHits;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.IndexWriterFactories;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriter;
import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.unsafe.batchinsert.BatchInserterIndex;

class LuceneBatchInserterIndex
implements BatchInserterIndex {
    private final IndexIdentifier identifier;
    private final IndexType type;
    private LuceneIndexWriter writer;
    private SearcherManager searcherManager;
    private final boolean createdNow;
    private Map<String, LruCache<String, Collection<Long>>> cache;
    private int updateCount;
    private final int commitBatchSize = 500000;
    private final RelationshipLookup relationshipLookup;

    LuceneBatchInserterIndex(File dbStoreDir, IndexIdentifier identifier, Map<String, String> config, RelationshipLookup relationshipLookup) {
        File storeDir = this.getStoreDir(dbStoreDir);
        this.createdNow = !LuceneDataSource.getFileDirectory(storeDir, identifier).exists();
        this.identifier = identifier;
        this.type = IndexType.getIndexType(config);
        this.relationshipLookup = relationshipLookup;
        this.writer = this.instantiateWriter(storeDir);
        this.searcherManager = LuceneBatchInserterIndex.instantiateSearcherManager(this.writer);
    }

    public void add(long id, Map<String, Object> properties) {
        try {
            Document document = IndexType.newDocument(this.entityId(id));
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                this.addSingleProperty(id, document, key, value);
            }
            this.writer.addDocument(document);
            if (++this.updateCount == 500000) {
                this.writer.commit();
                this.updateCount = 0;
            }
        }
        catch (IOException | IndexCapacityExceededException e) {
            throw new RuntimeException(e);
        }
    }

    private Object entityId(long id) {
        if (this.identifier.entityType == IndexEntityType.Node) {
            return id;
        }
        return this.relationshipLookup.lookup(id);
    }

    private void addSingleProperty(long entityId, Document document, String key, Object value) {
        for (Object oneValue : IoPrimitiveUtils.asArray((Object)value)) {
            boolean isValueContext = oneValue instanceof ValueContext;
            oneValue = isValueContext ? ((ValueContext)oneValue).getCorrectValue() : oneValue.toString();
            this.type.addToDocument(document, key, oneValue);
            if (!this.createdNow) continue;
            this.addToCache(entityId, key, oneValue);
        }
    }

    private void addToCache(long entityId, String key, Object value) {
        if (this.cache == null) {
            return;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<Long>> cache = this.cache.get(key);
        if (cache != null) {
            HashSet<Long> ids = (HashSet<Long>)cache.get((Object)valueAsString);
            if (ids == null) {
                ids = new HashSet<Long>();
                cache.put((Object)valueAsString, ids);
            }
            ids.add(entityId);
        }
    }

    private void addToCache(Collection<Long> ids, String key, Object value) {
        if (this.cache == null) {
            return;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<Long>> cache = this.cache.get(key);
        if (cache != null) {
            cache.put((Object)valueAsString, ids);
        }
    }

    private LegacyIndexHits getFromCache(String key, Object value) {
        Collection ids;
        if (this.cache == null) {
            return null;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<Long>> cache = this.cache.get(key);
        if (cache != null && (ids = (Collection)cache.get((Object)valueAsString)) != null) {
            return new ConstantScoreIterator(ids, Float.NaN);
        }
        return null;
    }

    public void updateOrAdd(long entityId, Map<String, Object> properties) {
        try {
            this.removeFromCache(entityId);
            this.writer.deleteDocuments(this.type.idTermQuery(entityId));
            this.add(entityId, properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(long entityId) throws IOException, CorruptIndexException {
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            Query query = this.type.idTermQuery(entityId);
            TopDocs docs = searcher.search(query, 1);
            if (docs.totalHits > 0) {
                Document document = searcher.doc(docs.scoreDocs[0].doc);
                for (Fieldable field : document.getFields()) {
                    String key = field.name();
                    String value = field.stringValue();
                    this.removeFromCache(entityId, key, value);
                }
            }
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
    }

    private void removeFromCache(long entityId, String key, Object value) {
        Collection ids;
        if (this.cache == null) {
            return;
        }
        String valueAsString = value.toString();
        LruCache<String, Collection<Long>> cache = this.cache.get(key);
        if (cache != null && (ids = (Collection)cache.get((Object)valueAsString)) != null) {
            ids.remove(entityId);
        }
    }

    private LuceneIndexWriter instantiateWriter(File directory) {
        try {
            IndexWriterConfig writerConfig = new IndexWriterConfig(LuceneDataSource.LUCENE_VERSION, this.type.analyzer);
            writerConfig.setRAMBufferSizeMB(this.determineGoodBufferSize(writerConfig.getRAMBufferSizeMB()));
            Directory luceneDir = LuceneDataSource.getDirectory(directory, this.identifier);
            return IndexWriterFactories.batchInsert(writerConfig).create(luceneDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private double determineGoodBufferSize(double atLeast) {
        double heapHint = Runtime.getRuntime().maxMemory() / 0xE00000L;
        double result = Math.max(atLeast, heapHint);
        return Math.min(result, 700.0);
    }

    private static SearcherManager instantiateSearcherManager(LuceneIndexWriter writer) {
        try {
            return writer.createSearcherManager();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeSearcher() {
        try {
            this.searcherManager.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.searcherManager = null;
        }
    }

    private void closeWriter() {
        try {
            if (this.writer != null) {
                this.writer.optimize();
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writer = null;
        }
    }

    private IndexHits<Long> query(Query query, final String key, final Object value) {
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            Hits hits = new Hits(searcher, query, null);
            HitsIterator result = new HitsIterator(hits);
            DocToIdIterator primitiveHits = null;
            primitiveHits = key == null || this.cache == null || !this.cache.containsKey(key) ? new DocToIdIterator(result, Collections.emptyList(), null, PrimitiveLongCollections.emptySet()) : new DocToIdIterator(result, Collections.emptyList(), null, PrimitiveLongCollections.emptySet()){
                private final Collection<Long> ids;
                {
                    super((IndexHits<Document>)x0, x1, x2, x3);
                    this.ids = new ArrayList<Long>();
                }

                @Override
                protected boolean fetchNext() {
                    if (super.fetchNext()) {
                        this.ids.add(this.next);
                        return true;
                    }
                    LuceneBatchInserterIndex.this.addToCache(this.ids, key, value);
                    return false;
                }
            };
            IndexHits<Long> indexHits = this.wrapIndexHits(primitiveHits);
            return indexHits;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.searcherManager.release((Object)searcher);
            }
            catch (IOException ignore) {}
        }
    }

    private IndexHits<Long> wrapIndexHits(final LegacyIndexHits ids) {
        return new IndexHits<Long>(){

            public boolean hasNext() {
                return ids.hasNext();
            }

            public Long next() {
                return ids.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public ResourceIterator<Long> iterator() {
                return this;
            }

            public int size() {
                return ids.size();
            }

            public void close() {
                ids.close();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Long getSingle() {
                try {
                    long singleId = PrimitiveLongCollections.single((PrimitiveLongIterator)ids, (long)-1L);
                    Long l = singleId == -1L ? null : Long.valueOf(singleId);
                    return l;
                }
                finally {
                    this.close();
                }
            }

            public float currentScore() {
                return 0.0f;
            }
        };
    }

    public IndexHits<Long> get(String key, Object value) {
        LegacyIndexHits cached = this.getFromCache(key, value);
        return cached != null ? this.wrapIndexHits(cached) : this.query(this.type.get(key, value), key, value);
    }

    public IndexHits<Long> query(String key, Object queryOrQueryObject) {
        return this.query(this.type.query(key, queryOrQueryObject, null), null, null);
    }

    public IndexHits<Long> query(Object queryOrQueryObject) {
        return this.query(this.type.query(null, queryOrQueryObject, null), null, null);
    }

    public void shutdown() {
        this.closeSearcher();
        this.closeWriter();
    }

    private File getStoreDir(File dbStoreDir) {
        File dir = new File(dbStoreDir, "index");
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Unable to create directory path[" + dir.getAbsolutePath() + "] for Neo4j store.");
        }
        return dir;
    }

    public void flush() {
        try {
            while (!this.searcherManager.maybeRefresh()) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCacheCapacity(String key, int size) {
        LruCache cache;
        if (this.cache == null) {
            this.cache = new HashMap<String, LruCache<String, Collection<Long>>>();
        }
        if ((cache = this.cache.get(key)) != null) {
            cache.resize(size);
        } else {
            cache = new LruCache("Batch inserter cache for " + key, size);
            this.cache.put(key, (LruCache<String, Collection<Long>>)cache);
        }
    }

    static interface RelationshipLookup {
        public RelationshipId lookup(long var1);
    }
}

