/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.drools.agent.FileLoader;
import org.drools.agent.PackageProvider;
import org.drools.agent.RuleAgent;
import org.drools.common.DroolsObjectInputStream;
import org.drools.rule.Package;

public class FileScanner
extends PackageProvider {
    File[] files;
    Map lastUpdated = new HashMap();

    void configure(Properties config) {
        List paths = RuleAgent.list(config.getProperty("file"));
        this.files = new File[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            File file = new File((String)paths.get(i));
            if (!file.exists()) {
                throw new IllegalArgumentException("The file " + file.getName() + " does not exist.");
            }
            this.files[i] = file;
        }
    }

    void setFiles(File[] files) {
        this.files = files;
    }

    Package[] loadPackageChanges() {
        Package[] changes = this.getChangeSet();
        return changes;
    }

    private Package[] getChangeSet() {
        if (this.files == null) {
            return new Package[0];
        }
        ArrayList<Package> list = new ArrayList<Package>();
        for (int i = 0; i < this.files.length; ++i) {
            Package p;
            File f = this.files[i];
            if (!this.hasChanged(f.getPath(), this.lastUpdated, f.lastModified()) || (p = this.readPackage(f)) == null) continue;
            list.add(p);
        }
        return list.toArray(new Package[list.size()]);
    }

    private Package readPackage(File pkgFile) {
        String name = pkgFile.getName();
        if (!name.endsWith(".pkg") && !name.endsWith(".drl")) {
            return null;
        }
        if (name.endsWith(".drl")) {
            try {
                FileLoader fl = (FileLoader)Class.forName("org.drools.compiler.SourcePackageProvider").newInstance();
                return fl.loadPackage(pkgFile);
            }
            catch (Exception e) {
                this.listener.exception(e);
                return null;
            }
        }
        Package p1_ = null;
        try {
            DroolsObjectInputStream in = new DroolsObjectInputStream(new FileInputStream(pkgFile));
            p1_ = (Package)in.readObject();
            in.close();
        }
        catch (FileNotFoundException e) {
            this.listener.exception(e);
            this.listener.warning("Was unable to find the file " + pkgFile.getPath());
        }
        catch (IOException e) {
            this.listener.exception(e);
        }
        catch (ClassNotFoundException e) {
            this.listener.exception(e);
            this.listener.warning("Was unable to load a class when loading a package. Perhaps it is missing from this application.");
        }
        return p1_;
    }

    boolean hasChanged(String path, Map updates, long fileLastModified) {
        if (!updates.containsKey(path)) {
            updates.put(path, new Long(fileLastModified));
            return true;
        }
        Long last = (Long)updates.get(path);
        if (last < fileLastModified) {
            updates.put(path, new Long(fileLastModified));
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("FileScanner scanning: ");
        for (int i = 0; i < this.files.length; ++i) {
            File f = this.files[i];
            buf.append(f.getPath() + " ");
        }
        return buf.toString();
    }
}

