/*
 * Decompiled with CFR 0.152.
 */
package org.drools.concurrent;

import java.io.Serializable;
import org.drools.WorkingMemory;
import org.drools.concurrent.Command;
import org.drools.concurrent.Future;
import org.drools.util.concurrent.locks.BlockingQueue;
import org.drools.util.concurrent.locks.LinkedBlockingQueue;

public class CommandExecutor
implements Runnable,
Serializable {
    private static final long serialVersionUID = 5924295088331461167L;
    private WorkingMemory workingMemory;
    private BlockingQueue queue;
    private volatile boolean run;

    public CommandExecutor(WorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.queue = new LinkedBlockingQueue();
    }

    public void shutdown() {
        this.run = false;
    }

    public Future submit(Command command) {
        this.queue.offer(command);
        return (Future)((Object)command);
    }

    public void run() {
        this.run = true;
        while (this.run) {
            try {
                Command executor = (Command)this.queue.take();
                executor.execute(this.workingMemory);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

