/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;

public class EnvironmentFailureException
extends RunRecoveryException {
    private static final long serialVersionUID = 1L;
    private boolean alreadyThrown;
    private EnvironmentFailureReason reason;

    private EnvironmentFailureException(String msg) {
        super(msg);
    }

    private EnvironmentFailureException(EnvironmentFailureReason reason, String message, Throwable cause) {
        this(null, reason, message, cause);
    }

    public EnvironmentFailureException(EnvironmentImpl envImpl, EnvironmentFailureReason reason) {
        this(envImpl, reason, null, null);
    }

    public EnvironmentFailureException(EnvironmentImpl envImpl, EnvironmentFailureReason reason, Throwable cause) {
        this(envImpl, reason, null, cause);
    }

    public EnvironmentFailureException(EnvironmentImpl envImpl, EnvironmentFailureReason reason, String message) {
        this(envImpl, reason, message, null);
    }

    public EnvironmentFailureException(EnvironmentImpl envImpl, EnvironmentFailureReason reason, String message, Throwable cause) {
        super(EnvironmentFailureException.makeMsg(envImpl, reason, message, cause), cause);
        if (reason.invalidatesEnvironment()) {
            assert (envImpl != null);
            envImpl.invalidate(this);
        }
        this.reason = reason;
    }

    private static String makeMsg(EnvironmentImpl envImpl, EnvironmentFailureReason reason, String message, Throwable cause) {
        StringBuilder s = new StringBuilder(300);
        if (envImpl != null) {
            s.append(envImpl.getName()).append(" ");
        }
        if (message != null) {
            s.append(message);
            s.append(' ');
        } else if (cause != null) {
            s.append(cause.toString());
            s.append(' ');
        }
        assert (reason != null);
        s.append((Object)reason);
        if (reason.invalidatesEnvironment() || envImpl != null && !envImpl.isValid()) {
            s.append(" Environment is invalid and must be closed.");
        }
        return s.toString();
    }

    protected EnvironmentFailureException(String message, EnvironmentFailureException cause) {
        super(message, cause);
        assert (cause != null);
        this.reason = cause.reason;
    }

    public EnvironmentFailureException wrapSelf(String msg) {
        assert (EnvironmentFailureException.class == this.getClass()) : "Missing overriding " + this.getClass().getName() + ".wrapSelf() method";
        return new EnvironmentFailureException(msg, this);
    }

    public void setAlreadyThrown(boolean alreadyThrown) {
        this.alreadyThrown = alreadyThrown;
    }

    public String getMessage() {
        if (this.reason == EnvironmentFailureReason.JAVA_ERROR || !this.alreadyThrown) {
            return super.getMessage();
        }
        return "Environment invalid because of previous exception: " + super.getMessage();
    }

    public EnvironmentFailureReason getReason() {
        return this.reason;
    }

    public static EnvironmentFailureException makeJavaErrorWrapper() {
        EnvironmentFailureException e = new EnvironmentFailureException(EnvironmentFailureReason.JAVA_ERROR.toString());
        e.reason = EnvironmentFailureReason.JAVA_ERROR;
        return e;
    }

    public static EnvironmentFailureException promote(EnvironmentImpl envImpl, EnvironmentFailureReason reason, String message, Throwable cause) {
        if (cause instanceof EnvironmentFailureException) {
            EnvironmentFailureException e = (EnvironmentFailureException)cause;
            e.addErrorMessage(message);
            return e;
        }
        return new EnvironmentFailureException(envImpl, reason, message, cause);
    }

    public static EnvironmentFailureException unexpectedException(Exception cause) {
        return new EnvironmentFailureException(EnvironmentFailureReason.UNEXPECTED_EXCEPTION, null, (Throwable)cause);
    }

    public static EnvironmentFailureException unexpectedException(EnvironmentImpl envImpl, Exception cause) {
        return new EnvironmentFailureException(envImpl, EnvironmentFailureReason.UNEXPECTED_EXCEPTION_FATAL, null, cause);
    }

    public static EnvironmentFailureException unexpectedException(String message, Exception cause) {
        return new EnvironmentFailureException(EnvironmentFailureReason.UNEXPECTED_EXCEPTION, message, (Throwable)cause);
    }

    public static EnvironmentFailureException unexpectedException(EnvironmentImpl envImpl, String message, Exception cause) {
        return new EnvironmentFailureException(envImpl, EnvironmentFailureReason.UNEXPECTED_EXCEPTION_FATAL, message, cause);
    }

    public static EnvironmentFailureException unexpectedState() {
        return new EnvironmentFailureException(EnvironmentFailureReason.UNEXPECTED_STATE, null, null);
    }

    public static EnvironmentFailureException unexpectedState(EnvironmentImpl envImpl) {
        return new EnvironmentFailureException(envImpl, EnvironmentFailureReason.UNEXPECTED_STATE_FATAL, null, null);
    }

    public static EnvironmentFailureException unexpectedState(String message) {
        return new EnvironmentFailureException(EnvironmentFailureReason.UNEXPECTED_STATE, message, null);
    }

    public static EnvironmentFailureException unexpectedState(EnvironmentImpl envImpl, String message) {
        return new EnvironmentFailureException(envImpl, EnvironmentFailureReason.UNEXPECTED_STATE_FATAL, message, null);
    }

    public static void assertState(boolean cond) {
        if (!cond) {
            throw EnvironmentFailureException.unexpectedState((String)null);
        }
    }

    public static void assertState(boolean cond, String message) {
        if (!cond) {
            throw EnvironmentFailureException.unexpectedState(message);
        }
    }
}

