/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.latch;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class LatchTable {
    private ThreadLocal<Set<Object>> latchesByThread = new ThreadLocal();

    LatchTable() {
    }

    boolean noteLatch(Object latch) {
        Set<Object> threadLatches = this.latchesByThread.get();
        if (threadLatches == null) {
            threadLatches = new HashSet<Object>();
            this.latchesByThread.set(threadLatches);
        }
        threadLatches.add(latch);
        return true;
    }

    boolean unNoteLatch(Object latch, String name) {
        Set<Object> threadLatches = this.latchesByThread.get();
        if (threadLatches == null) {
            return false;
        }
        return threadLatches.remove(latch);
    }

    int countLatchesHeld() {
        Set<Object> threadLatches = this.latchesByThread.get();
        if (threadLatches != null) {
            return threadLatches.size();
        }
        return 0;
    }

    String latchesHeldToString() {
        Set<Object> threadLatches = this.latchesByThread.get();
        StringBuilder sb = new StringBuilder();
        if (threadLatches != null) {
            Iterator<Object> i = threadLatches.iterator();
            while (i.hasNext()) {
                sb.append(i.next()).append('\n');
            }
        }
        return sb.toString();
    }

    void clearNotes() {
        this.latchesByThread = new ThreadLocal();
    }
}

