/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.BaseEntry;
import com.sleepycat.je.log.entry.INContainingEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INLogEntry<T extends IN>
extends BaseEntry<T>
implements LogEntry,
INContainingEntry {
    private T in;
    private DatabaseId dbId;
    private long prevFullLsn;
    private long prevDeltaLsn;

    public static <T extends IN> INLogEntry<T> create(Class<T> INClass) {
        return new INLogEntry<Class<T>>(INClass);
    }

    private INLogEntry(Class<T> INClass) {
        super(INClass);
    }

    public INLogEntry(T in) {
        this.setLogType(((IN)in).getLogType());
        this.in = in;
        this.dbId = ((IN)in).getDatabase().getId();
        this.prevFullLsn = ((IN)in).getLastFullVersion();
        this.prevDeltaLsn = ((IN)in).getLastDeltaVersion();
    }

    @Override
    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        boolean version6OrLater;
        int logVersion = header.getVersion();
        boolean bl = version6OrLater = logVersion >= 6;
        if (version6OrLater) {
            this.dbId = new DatabaseId();
            this.dbId.readFromLog(entryBuffer, logVersion);
            this.prevFullLsn = LogUtils.readLong(entryBuffer, false);
            if (logVersion >= 8) {
                this.prevDeltaLsn = LogUtils.readPackedLong(entryBuffer);
            }
        }
        this.in = (IN)this.newInstanceOfType();
        ((IN)this.in).readFromLog(entryBuffer, logVersion);
        if (!version6OrLater) {
            this.dbId = new DatabaseId();
            this.dbId.readFromLog(entryBuffer, logVersion);
        }
        if (logVersion < 1) {
            this.prevFullLsn = -1L;
        } else if (logVersion == 1) {
            long fileNum = LogUtils.readUnsignedInt(entryBuffer);
            this.prevFullLsn = fileNum == 0xFFFFFFFFL ? -1L : DbLsn.makeLsn(fileNum, 0);
        } else if (!version6OrLater) {
            this.prevFullLsn = LogUtils.readLong(entryBuffer, true);
        }
    }

    @Override
    public long getPrevFullLsn() {
        return this.prevFullLsn;
    }

    @Override
    public long getPrevDeltaLsn() {
        return this.prevDeltaLsn;
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        ((IN)this.in).dumpLog(sb, verbose);
        this.dbId.dumpLog(sb, verbose);
        if (this.prevFullLsn != -1L) {
            sb.append("<prevFullLsn>");
            sb.append(DbLsn.getNoFormatString(this.prevFullLsn));
            sb.append("</prevFullLsn>");
        }
        if (this.prevDeltaLsn != -1L) {
            sb.append("<prevDeltaLsn>");
            sb.append(DbLsn.getNoFormatString(this.prevDeltaLsn));
            sb.append("</prevDeltaLsn>");
        }
        return sb;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
    }

    @Override
    public Object getMainItem() {
        return this.in;
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public int getSize() {
        return ((IN)this.in).getLogSize() + this.dbId.getLogSize() + LogUtils.getPackedLongLogSize(this.prevFullLsn) + LogUtils.getPackedLongLogSize(this.prevDeltaLsn);
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer) {
        this.dbId.writeToLog(destBuffer);
        LogUtils.writePackedLong(destBuffer, this.prevFullLsn);
        LogUtils.writePackedLong(destBuffer, this.prevDeltaLsn);
        ((IN)this.in).writeToLog(destBuffer);
    }

    @Override
    public IN getIN(DatabaseImpl dbImpl) {
        return this.in;
    }

    public long getNodeId() {
        return ((IN)this.in).getNodeId();
    }

    @Override
    public DatabaseId getDbId() {
        return this.dbId;
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        return false;
    }
}

