/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoReader {
    public final LNLogEntry<?> logEntry;
    public final LN ln;
    private final long lsn;
    public final DatabaseImpl db;

    private UndoReader(LNLogEntry<?> logEntry, LN ln, long lsn, DatabaseImpl db) {
        this.logEntry = logEntry;
        this.ln = ln;
        this.lsn = lsn;
        this.db = db;
    }

    public static UndoReader create(EnvironmentImpl envImpl, long undoLsn, Map<DatabaseId, DatabaseImpl> undoDatabases) {
        LNLogEntry logEntry = (LNLogEntry)envImpl.getLogManager().getLogEntryHandleFileNotFound(undoLsn);
        DatabaseId dbId = logEntry.getDbId();
        DatabaseImpl db = undoDatabases.get(dbId);
        if (db == null) {
            throw EnvironmentFailureException.unexpectedState(envImpl, "DB not found during non-recovery undo/rollback, id=" + dbId);
        }
        logEntry.postFetchInit(db);
        LN ln = logEntry.getLN();
        long lsn = undoLsn;
        ln.postFetchInit(db, undoLsn);
        return new UndoReader(logEntry, ln, lsn, db);
    }

    public static UndoReader createForRecovery(LNFileReader reader, DbTree dbMapTree) {
        LNLogEntry<?> logEntry = reader.getLNLogEntry();
        DatabaseId dbId = logEntry.getDbId();
        DatabaseImpl db = dbMapTree.getDb(dbId);
        if (db == null) {
            return null;
        }
        logEntry.postFetchInit(db);
        LN ln = logEntry.getLN();
        long lsn = reader.getLastLsn();
        ln.postFetchInit(db, lsn);
        return new UndoReader(logEntry, ln, lsn, db);
    }

    public String toString() {
        return this.ln + " lsn=" + DbLsn.getNoFormatString(this.lsn);
    }
}

