/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.protempa.MalformedTermIdException;
import org.protempa.Terminology;

public final class Term {
    private final String id;
    private final String code;
    private final Terminology terminology;
    private String displayName;
    private String description;
    private String semanticType;
    private String abbrevDisplayName;
    private String[] inverseIsA;
    private String[] directChildren;
    private static Pattern idPattern = Pattern.compile(".+:.+");

    private static boolean checkId(String id) {
        return idPattern.matcher(id).matches();
    }

    private Term(String id, String terminology, String code) {
        this(id, Terminology.withName(terminology), code);
    }

    private Term(String id, Terminology terminology, String code) {
        this.id = id;
        this.terminology = terminology;
        this.code = code;
        this.displayName = "";
        this.abbrevDisplayName = "";
    }

    private Term(String terminology, String code) {
        this(Term.makeId(Terminology.withName(terminology), code), terminology, code);
    }

    public static Term withId(String id) throws MalformedTermIdException {
        if (Term.checkId(id)) {
            String[] parts = Term.parseId(id);
            Term term = new Term(id, parts[0], parts[1]);
            return term;
        }
        throw new MalformedTermIdException("Bad term ID: " + id + "\nTerm IDs must be of the form: <terminology name>:<terminology code>");
    }

    public static Term fromTerminologyAndCode(String terminology, String code) {
        return new Term(terminology, code);
    }

    private static String makeId(Terminology terminology, String code) {
        return terminology.getName() + ":" + code;
    }

    private static String[] parseId(String id) {
        return id.split(":");
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        if (displayName == null) {
            displayName = "";
        }
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSemanticType() {
        return this.semanticType;
    }

    public void setSemanticType(String semanticType) {
        this.semanticType = semanticType;
    }

    public String getAbbrevDisplayName() {
        return this.abbrevDisplayName;
    }

    public void setAbbrevDisplayName(String abbrevDisplayName) {
        if (abbrevDisplayName == null) {
            abbrevDisplayName = "";
        }
        this.abbrevDisplayName = abbrevDisplayName;
    }

    public String[] getInverseIsA() {
        return (String[])this.inverseIsA.clone();
    }

    public void setInverseIsA(String[] inverseIsA) {
        if (inverseIsA == null) {
            inverseIsA = ArrayUtils.EMPTY_STRING_ARRAY;
        }
        this.inverseIsA = (String[])inverseIsA.clone();
    }

    public String[] getDirectChildren() {
        return (String[])this.directChildren.clone();
    }

    public void setDirectChildren(String[] directChildren) {
        if (directChildren == null) {
            directChildren = ArrayUtils.EMPTY_STRING_ARRAY;
        }
        this.directChildren = (String[])directChildren.clone();
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public Terminology getTerminology() {
        return this.terminology;
    }
}

