/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.datastore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.arp.javautil.datastore.BdbPersistentStoreFactory;
import org.arp.javautil.datastore.DataStore;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.protempa.datastore.DataStoreUtil;

final class DroolsWorkingMemoryStore
implements DataStore<String, WorkingMemory> {
    private final DataStore<String, byte[]> store;
    private boolean isClosed;
    private final RuleBase ruleBase;

    DroolsWorkingMemoryStore(BdbPersistentStoreFactory storeFactory, String dbName, RuleBase ruleBase) {
        this.store = storeFactory.newInstance(dbName);
        this.isClosed = false;
        this.ruleBase = ruleBase;
    }

    public void shutdown() {
        this.store.shutdown();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private WorkingMemory readWorkingMemory(byte[] barr) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(barr);
            StatefulSession wm = this.ruleBase.newStatefulSession((InputStream)bais, false);
            bais.close();
            return wm;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new IOError(ex);
        }
    }

    private byte[] writeWorkingMemory(WorkingMemory wm) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(wm);
            byte[] result = baos.toByteArray();
            oos.close();
            baos.close();
            DataStoreUtil.logger().log(Level.FINEST, "Working memory size: {0}", result.length);
            return result;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public WorkingMemory get(Object key) {
        WorkingMemory retval = key instanceof String ? this.readWorkingMemory((byte[])this.store.get(key)) : null;
        return retval;
    }

    public WorkingMemory put(String key, WorkingMemory value) {
        this.store.put((Object)key, (Object)this.writeWorkingMemory(value));
        return value;
    }

    public int size() {
        return this.store.size();
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.store.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.store.containsValue(value);
    }

    public WorkingMemory remove(Object key) {
        return this.readWorkingMemory((byte[])this.store.remove(key));
    }

    public void putAll(Map<? extends String, ? extends WorkingMemory> m) {
        for (Map.Entry<? extends String, ? extends WorkingMemory> e : m.entrySet()) {
            this.store.put((Object)e.getKey(), (Object)this.writeWorkingMemory(e.getValue()));
        }
    }

    public void clear() {
        this.store.clear();
    }

    public Set<String> keySet() {
        return this.store.keySet();
    }

    public Collection<WorkingMemory> values() {
        ArrayList<WorkingMemory> values = new ArrayList<WorkingMemory>();
        for (byte[] barr : this.store.values()) {
            values.add(this.readWorkingMemory(barr));
        }
        return Collections.unmodifiableCollection(values);
    }

    public Set<Map.Entry<String, WorkingMemory>> entrySet() {
        HashSet<Map.Entry<String, WorkingMemory>> entrySet = new HashSet<Map.Entry<String, WorkingMemory>>();
        for (String key : this.store.keySet()) {
            entrySet.add(new LazyEntry(key));
        }
        return entrySet;
    }

    private class LazyEntry
    implements Map.Entry<String, WorkingMemory> {
        private final String key;

        public LazyEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public WorkingMemory getValue() {
            return DroolsWorkingMemoryStore.this.readWorkingMemory((byte[])DroolsWorkingMemoryStore.this.store.get((Object)this.key));
        }

        @Override
        public WorkingMemory setValue(WorkingMemory value) {
            throw new UnsupportedOperationException("setValue not supported");
        }
    }
}

