/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.deid;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.protempa.dest.deid.CipherDeidConfig;
import org.protempa.dest.deid.DecryptException;
import org.protempa.dest.deid.EncryptException;
import org.protempa.dest.deid.Encryption;
import org.protempa.dest.deid.EncryptionInitException;

public class CipherEncryption
implements Encryption {
    private Cipher encryptCipher;
    private Cipher decryptCipher;
    private final CipherDeidConfig deidConfig;
    private final KeyGenerator keygen;

    public CipherEncryption(CipherDeidConfig deidConfig) throws EncryptionInitException {
        if (deidConfig == null) {
            throw new IllegalArgumentException("deidConfig cannot be null");
        }
        this.deidConfig = deidConfig;
        try {
            this.keygen = KeyGenerator.getInstance(this.deidConfig.getKeyAlgorithm());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptionInitException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCiphers() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        KeyGenerator keyGenerator = this.keygen;
        synchronized (keyGenerator) {
            if (this.encryptCipher == null) {
                SecretKey key = this.keygen.generateKey();
                this.encryptCipher = Cipher.getInstance(this.deidConfig.getCipherAlgorithm());
                this.encryptCipher.init(1, key);
                this.decryptCipher = Cipher.getInstance(this.deidConfig.getCipherAlgorithm());
                this.decryptCipher.init(2, key);
            }
        }
    }

    @Override
    public String encrypt(String keyId, String str) throws EncryptException {
        if (str == null) {
            return null;
        }
        try {
            this.initCiphers();
            byte[] cleartext = str.getBytes("UTF-8");
            byte[] ciphertext = this.encryptCipher.doFinal(cleartext);
            return Base64.encodeBase64String((byte[])ciphertext);
        }
        catch (InvalidKeyException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new EncryptException("Could not encrypt string", ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)"UTF-8 should be supported but is not");
        }
    }

    String decrypt(String str) throws DecryptException {
        if (str == null) {
            return null;
        }
        try {
            this.initCiphers();
            byte[] ciphertext = Base64.decodeBase64((String)str);
            byte[] cleartext = this.decryptCipher.doFinal(ciphertext);
            return new String(cleartext);
        }
        catch (NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new DecryptException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

