/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.deid;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.protempa.dest.deid.Encryption;
import org.protempa.dest.deid.EncryptionInitException;
import org.protempa.dest.deid.MessageDigestDeidConfig;

public class MessageDigestEncryption
implements Encryption {
    private final MessageDigestDeidConfig deidConfig;
    private final MessageDigest messageDigest;

    public MessageDigestEncryption(MessageDigestDeidConfig deidConfig) throws EncryptionInitException {
        if (deidConfig == null) {
            throw new IllegalArgumentException("deidConfig cannot be null");
        }
        this.deidConfig = deidConfig;
        String algorithm = this.deidConfig.getAlgorithm();
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptionInitException(ex);
        }
    }

    @Override
    public String encrypt(String keyId, String inData) {
        if (keyId == null) {
            throw new IllegalArgumentException("keyId cannot be null");
        }
        if (inData == null) {
            return null;
        }
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            byte[] salt = this.deidConfig.getSalt(keyId);
            if (salt != null) {
                this.messageDigest.update(salt);
            }
            try {
                byte[] digested = this.messageDigest.digest(inData.getBytes("UTF-8"));
                return Base64.encodeBase64String((byte[])digested);
            }
            catch (UnsupportedEncodingException ex) {
                throw new AssertionError((Object)"UTF-8 should be supported but is not");
            }
        }
    }
}

