/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.io.BufferedWriter;
import java.util.HashSet;
import org.arp.javautil.arrays.Arrays;
import org.protempa.DataSource;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.dest.AbstractDestination;
import org.protempa.dest.GetSupportedPropositionIdsException;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.table.TableColumnSpec;
import org.protempa.dest.table.TableQueryResultsHandler;
import org.protempa.query.Query;
import org.protempa.query.QueryMode;

public final class TableDestination
extends AbstractDestination {
    private final boolean headerWritten;
    private final TableColumnSpec[] columnSpecs;
    private final String[] rowPropositionIds;
    private final char columnDelimiter;
    private final BufferedWriter out;

    public TableDestination(BufferedWriter out, char columnDelimiter, String[] rowPropositionIds, TableColumnSpec[] columnSpecs, boolean headerWritten) {
        this.out = out;
        this.columnDelimiter = columnDelimiter;
        this.rowPropositionIds = (String[])rowPropositionIds.clone();
        this.columnSpecs = (TableColumnSpec[])columnSpecs.clone();
        this.headerWritten = headerWritten;
    }

    public String[] getRowPropositionIds() {
        return (String[])this.rowPropositionIds.clone();
    }

    public char getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public TableColumnSpec[] getColumnSpecs() {
        return (TableColumnSpec[])this.columnSpecs.clone();
    }

    public boolean isHeaderWritten() {
        return this.headerWritten;
    }

    @Override
    public TableQueryResultsHandler getQueryResultsHandler(Query query, DataSource dataSource, KnowledgeSource knowledgeSource) throws QueryResultsHandlerInitException {
        if (query.getQueryMode() == QueryMode.UPDATE) {
            throw new QueryResultsHandlerInitException("Update mode not supported");
        }
        return new TableQueryResultsHandler(this.out, this.columnDelimiter, this.rowPropositionIds, this.columnSpecs, this.headerWritten, knowledgeSource);
    }

    @Override
    public String[] getSupportedPropositionIds(DataSource dataSource, KnowledgeSource knowledgeSource) throws GetSupportedPropositionIdsException {
        HashSet result = new HashSet();
        Arrays.addAll(result, (Object[][])new String[][]{this.rowPropositionIds});
        for (TableColumnSpec columnSpec : this.columnSpecs) {
            String[] inferredPropIds;
            try {
                inferredPropIds = columnSpec.getInferredPropositionIds(knowledgeSource, this.rowPropositionIds);
            }
            catch (KnowledgeSourceReadException ex) {
                throw new GetSupportedPropositionIdsException("Error getting proposition ids needed", ex);
            }
            Arrays.addAll(result, (Object[][])new String[][]{inferredPropIds});
        }
        return result.toArray(new String[result.size()]);
    }
}

