/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.interval;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.arp.javautil.graph.BellmanFord;
import org.arp.javautil.graph.DirectedGraph;
import org.arp.javautil.graph.Weight;
import org.arp.javautil.graph.WeightFactory;
import org.protempa.proposition.interval.DirectionalPathConsistency;
import org.protempa.proposition.interval.Interval;

final class ConstraintNetwork {
    private static final String timeZero = "0";
    private final List<Interval> intervals;
    private final DirectedGraph directedGraph;
    private Weight calcMinDuration;
    private Weight calcMaxDuration;
    private Weight calcMinFinish;
    private Weight calcMaxFinish;
    private Weight calcMinStart;
    private Weight calcMaxStart;
    private Map<?, Weight> shortestDistancesFromTimeZeroSource;
    private Map<?, Weight> shortestDistancesFromTimeZeroDestination;

    ConstraintNetwork() {
        this(10);
    }

    ConstraintNetwork(int initialCapacity) {
        this.directedGraph = new DirectedGraph(initialCapacity * 2 + 1);
        this.directedGraph.add((Object)timeZero);
        this.intervals = new ArrayList<Interval>(initialCapacity);
    }

    synchronized void clear() {
        this.directedGraph.clear();
        this.intervals.clear();
        this.directedGraph.add((Object)timeZero);
        this.calcMinDuration = null;
        this.calcMaxDuration = null;
        this.calcMinFinish = null;
        this.calcMaxFinish = null;
        this.calcMinStart = null;
        this.calcMaxStart = null;
        this.shortestDistancesFromTimeZeroSource = null;
        this.shortestDistancesFromTimeZeroDestination = null;
    }

    synchronized boolean removeRelation(Interval i1, Interval i2) {
        if (i1 == i2 || !this.containsInterval(i1) || !this.containsInterval(i2)) {
            return false;
        }
        Interval.Start i1Start = i1.getStart();
        Interval.Finish i1Finish = i1.getFinish();
        Interval.Start i2Start = i2.getStart();
        Interval.Finish i2Finish = i2.getFinish();
        this.directedGraph.setEdge((Object)i1Start, (Object)i2Start, null);
        this.directedGraph.setEdge((Object)i1Start, (Object)i2Finish, null);
        this.directedGraph.setEdge((Object)i2Start, (Object)i1Start, null);
        this.directedGraph.setEdge((Object)i2Start, (Object)i1Finish, null);
        this.directedGraph.setEdge((Object)i1Finish, (Object)i2Start, null);
        this.directedGraph.setEdge((Object)i1Finish, (Object)i2Finish, null);
        this.directedGraph.setEdge((Object)i2Finish, (Object)i1Start, null);
        this.directedGraph.setEdge((Object)i2Finish, (Object)i1Finish, null);
        this.calcMinDuration = null;
        this.calcMaxDuration = null;
        this.calcMinFinish = null;
        this.calcMaxFinish = null;
        this.calcMinStart = null;
        this.calcMaxStart = null;
        this.shortestDistancesFromTimeZeroSource = null;
        this.shortestDistancesFromTimeZeroDestination = null;
        return true;
    }

    synchronized boolean removeInterval(Interval i) {
        this.calcMinDuration = null;
        this.calcMaxDuration = null;
        this.calcMinFinish = null;
        this.calcMaxFinish = null;
        this.calcMinStart = null;
        this.calcMaxStart = null;
        this.shortestDistancesFromTimeZeroSource = null;
        this.shortestDistancesFromTimeZeroDestination = null;
        if (this.directedGraph.remove((Object)i.getStart()) != null) {
            if (this.directedGraph.remove((Object)i.getFinish()) == null) {
                throw new IllegalStateException();
            }
            this.intervals.remove(i);
            return true;
        }
        return false;
    }

    private boolean containsInterval(Interval i) {
        if (i != null) {
            return this.directedGraph.contains((Object)i.getStart()) && this.directedGraph.contains((Object)i.getFinish());
        }
        return false;
    }

    synchronized boolean addInterval(Interval i) {
        if (i == null || this.containsInterval(i) || !this.intervals.add(i)) {
            return false;
        }
        Interval.Start iStart = i.getStart();
        Interval.Finish iFinish = i.getFinish();
        this.directedGraph.add((Object)iStart);
        this.directedGraph.add((Object)iFinish);
        Weight mindur = i.getSpecifiedMinimumLength();
        Weight maxdur = i.getSpecifiedMaximumLength();
        this.directedGraph.setEdge((Object)iStart, (Object)iFinish, maxdur);
        this.directedGraph.setEdge((Object)iFinish, (Object)iStart, mindur.invertSign());
        Weight minstart = i.getSpecifiedMinimumStart();
        Weight maxstart = i.getSpecifiedMaximumStart();
        this.directedGraph.setEdge((Object)timeZero, (Object)iStart, maxstart);
        this.directedGraph.setEdge((Object)iStart, (Object)timeZero, minstart.invertSign());
        Weight minfinish = i.getSpecifiedMinimumFinish();
        Weight maxfinish = i.getSpecifiedMaximumFinish();
        this.directedGraph.setEdge((Object)timeZero, (Object)iFinish, maxfinish);
        this.directedGraph.setEdge((Object)iFinish, (Object)timeZero, minfinish.invertSign());
        this.calcMinDuration = null;
        this.calcMaxDuration = null;
        this.calcMinFinish = null;
        this.calcMaxFinish = null;
        this.calcMinStart = null;
        this.calcMaxStart = null;
        this.shortestDistancesFromTimeZeroSource = null;
        this.shortestDistancesFromTimeZeroDestination = null;
        return true;
    }

    synchronized Weight getMinimumStart() {
        if (this.calcMinStart == null) {
            Weight result = WeightFactory.NEG_INFINITY;
            if (this.shortestDistancesFromTimeZeroDestination == null) {
                this.shortestDistancesFromTimeZeroDestination = BellmanFord.calcShortestDistances((Object)timeZero, (DirectedGraph)this.directedGraph, (BellmanFord.Mode)BellmanFord.Mode.DESTINATION);
                if (this.shortestDistancesFromTimeZeroDestination == null) {
                    throw new IllegalStateException("Negative cycle detected!");
                }
            }
            int n = this.intervals.size();
            for (int i = 0; i < n; ++i) {
                Interval.Start start = this.intervals.get(i).getStart();
                result = Weight.max((Weight)result, (Weight)this.shortestDistancesFromTimeZeroDestination.get(start));
            }
            this.calcMinStart = result.invertSign();
        }
        return this.calcMinStart;
    }

    synchronized Weight getMaximumStart() {
        if (this.calcMaxStart == null) {
            Weight result = WeightFactory.POS_INFINITY;
            if (this.shortestDistancesFromTimeZeroSource == null) {
                this.shortestDistancesFromTimeZeroSource = BellmanFord.calcShortestDistances((Object)timeZero, (DirectedGraph)this.directedGraph, (BellmanFord.Mode)BellmanFord.Mode.SOURCE);
                if (this.shortestDistancesFromTimeZeroSource == null) {
                    throw new IllegalStateException("Negative cycle detected!");
                }
            }
            int n = this.intervals.size();
            for (int i = 0; i < n; ++i) {
                Interval.Start start = this.intervals.get(i).getStart();
                result = Weight.min((Weight)result, (Weight)this.shortestDistancesFromTimeZeroSource.get(start));
            }
            this.calcMaxStart = result;
        }
        return this.calcMaxStart;
    }

    synchronized Weight getMinimumFinish() {
        if (this.calcMinFinish == null) {
            Weight result = WeightFactory.POS_INFINITY;
            if (this.shortestDistancesFromTimeZeroDestination == null) {
                this.shortestDistancesFromTimeZeroDestination = BellmanFord.calcShortestDistances((Object)timeZero, (DirectedGraph)this.directedGraph, (BellmanFord.Mode)BellmanFord.Mode.DESTINATION);
                if (this.shortestDistancesFromTimeZeroDestination == null) {
                    throw new IllegalStateException("Negative cycle detected!");
                }
            }
            int n = this.intervals.size();
            for (int i = 0; i < n; ++i) {
                Interval.Finish finish = this.intervals.get(i).getFinish();
                result = Weight.min((Weight)result, (Weight)this.shortestDistancesFromTimeZeroDestination.get(finish));
            }
            this.calcMinFinish = result.invertSign();
        }
        return this.calcMinFinish;
    }

    synchronized Weight getMaximumFinish() {
        if (this.calcMaxFinish == null) {
            Weight result = WeightFactory.NEG_INFINITY;
            if (this.shortestDistancesFromTimeZeroSource == null) {
                this.shortestDistancesFromTimeZeroSource = BellmanFord.calcShortestDistances((Object)timeZero, (DirectedGraph)this.directedGraph, (BellmanFord.Mode)BellmanFord.Mode.SOURCE);
                if (this.shortestDistancesFromTimeZeroSource == null) {
                    throw new IllegalStateException("Negative cycle detected!");
                }
            }
            int n = this.intervals.size();
            for (int i = 0; i < n; ++i) {
                Interval.Finish finish = this.intervals.get(i).getFinish();
                result = Weight.max((Weight)result, (Weight)this.shortestDistancesFromTimeZeroSource.get(finish));
            }
            this.calcMaxFinish = result;
        }
        return this.calcMaxFinish;
    }

    synchronized Weight getMaximumDuration() {
        if (this.calcMaxDuration == null) {
            Weight max = WeightFactory.ZERO;
            int n = this.intervals.size();
            for (int i = 0; i < n; ++i) {
                Interval.Start start = this.intervals.get(i).getStart();
                Map d = BellmanFord.calcShortestDistances((Object)start, (DirectedGraph)this.directedGraph, (BellmanFord.Mode)BellmanFord.Mode.SOURCE);
                if (d == null) {
                    throw new IllegalStateException("Negative cycle detected!");
                }
                for (int j = 0; j < n; ++j) {
                    Interval.Finish finish = this.intervals.get(j).getFinish();
                    max = Weight.max((Weight)max, (Weight)((Weight)d.get(finish)));
                }
            }
            this.calcMaxDuration = max;
        }
        return this.calcMaxDuration;
    }

    synchronized Weight getMinimumDuration() {
        if (this.calcMinDuration == null) {
            Weight min = WeightFactory.POS_INFINITY;
            int n = this.intervals.size();
            for (int i = 0; i < n; ++i) {
                Interval.Finish finish = this.intervals.get(i).getFinish();
                Map d = BellmanFord.calcShortestDistances((Object)finish, (DirectedGraph)this.directedGraph, (BellmanFord.Mode)BellmanFord.Mode.SOURCE);
                if (d == null) {
                    throw new IllegalStateException("Negative cycle detected!");
                }
                for (int j = 0; j < n; ++j) {
                    Interval.Start start = this.intervals.get(j).getStart();
                    min = Weight.min((Weight)min, (Weight)((Weight)d.get(start)));
                }
            }
            this.calcMinDuration = min.invertSign();
        }
        return this.calcMinDuration;
    }

    synchronized boolean getConsistent() {
        return DirectionalPathConsistency.getConsistent(this.directedGraph);
    }
}

