/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import org.protempa.KnowledgeSource;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.Value;
import org.protempa.xml.QueryConverter;
import org.protempa.xml.UnitValueConverter;
import org.protempa.xml.XMLConfiguration;

abstract class AbstractConverter
implements Converter {
    private final KnowledgeSource knowledgeSource;
    private static final UnitValueConverter unitConverter = new UnitValueConverter();
    private static Properties urlProperties = null;
    private static URL propertiesUrl;

    AbstractConverter(KnowledgeSource knowledgeSource) {
        this.knowledgeSource = knowledgeSource;
    }

    KnowledgeSource getKnowledgeSource() {
        return this.knowledgeSource;
    }

    protected void expect(HierarchicalStreamReader reader, String elementName) {
        if (!elementName.equals(reader.getNodeName())) {
            String msg = "Expected a " + elementName + " element but found " + reader.getNodeName();
            throw new ConversionException(msg);
        }
    }

    protected String expect(HierarchicalStreamReader reader, Set<String> elementNames) {
        String tag = reader.getNodeName();
        if (!elementNames.contains(tag)) {
            String msg = "Expected an element whose tag is one of " + elementNames + " but found " + reader.getNodeName();
            throw new ConversionException(msg);
        }
        return tag;
    }

    protected void expectNoMore(HierarchicalStreamReader reader) {
        if (reader.hasMoreChildren()) {
            String msg = "Element contains unexpected child elements";
            throw new ConversionException(msg);
        }
    }

    protected void expectChildren(HierarchicalStreamReader reader) {
        if (!reader.hasMoreChildren()) {
            String msg = "Element contains no child elements but is required to contain at least one.";
            throw new ConversionException(msg);
        }
    }

    protected String requiredAttributeValue(HierarchicalStreamReader reader, String attributeName) {
        String value = reader.getAttribute(attributeName);
        if (value == null) {
            this.missingAttribute(attributeName);
        }
        return value;
    }

    private void missingAttribute(String attributeName) {
        String msg = "The current element does not specify a value for an attribute named \"" + attributeName + "\"";
        throw new ConversionException(msg);
    }

    protected int intAttributeValue(HierarchicalStreamReader reader, String attributeName) {
        int value;
        String valueString = this.requiredAttributeValue(reader, attributeName);
        try {
            value = Integer.parseInt(valueString);
        }
        catch (Exception e) {
            String msg = "Unable to parse value of attribute n: \"" + valueString + "\"";
            throw new ConversionException(msg, (Throwable)e);
        }
        return value;
    }

    protected int intAttributeValue(HierarchicalStreamReader reader, String attributeName, int defaultValue) {
        int value;
        String valueString = reader.getAttribute(attributeName);
        if (valueString == null) {
            value = 1;
        } else {
            try {
                value = Integer.parseInt(valueString);
            }
            catch (Exception e) {
                String msg = "Unable to parse value of attribute n: \"" + valueString + "\"";
                throw new ConversionException(msg, (Throwable)e);
            }
        }
        return value;
    }

    protected Integer integerAttributeValue(HierarchicalStreamReader reader, String attributeName) {
        Integer value;
        String valueString = reader.getAttribute(attributeName);
        if (valueString == null) {
            value = null;
        } else {
            try {
                value = Integer.valueOf(valueString);
            }
            catch (Exception e) {
                String msg = "Unable to parse value of attribute n: \"" + valueString + "\"";
                throw new ConversionException(msg, (Throwable)e);
            }
        }
        return value;
    }

    protected Unit unitAttributeValue(HierarchicalStreamReader reader, String attributeName) {
        Unit value;
        String valueString = reader.getAttribute(attributeName);
        if (valueString == null) {
            value = null;
        } else {
            try {
                value = (Unit)unitConverter.fromString(valueString);
            }
            catch (Exception e) {
                String msg = "Unable to parse value of attribute n: \"" + valueString + "\"";
                throw new ConversionException(msg, (Throwable)e);
            }
        }
        return value;
    }

    protected void valueToXML(HierarchicalStreamWriter writer, MarshallingContext context, Value value) {
        Mapper mapper = XMLConfiguration.getTableQueryResultsHandlerXStream(this.knowledgeSource).getMapper();
        String valueElementTag = mapper.serializedClass(value.getClass());
        writer.startNode(valueElementTag);
        context.convertAnother((Object)value);
        writer.endNode();
    }

    protected Value valueFromXML(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        Mapper mapper = XMLConfiguration.getTableQueryResultsHandlerXStream(this.knowledgeSource).getMapper();
        Class type = mapper.realClass(reader.getNodeName());
        Value value = (Value)context.convertAnother(null, type);
        reader.moveUp();
        return value;
    }

    protected static URL getUrl(String propertyName) {
        String urlString;
        if (urlProperties == null) {
            propertiesUrl = QueryConverter.class.getResource("urls.properties");
            try {
                InputStream inStream = propertiesUrl.openStream();
                Properties props = new Properties();
                props.load(inStream);
                urlProperties = props;
            }
            catch (Exception e) {
                String msg = "Error occurred while trying to read properties from " + propertiesUrl.toExternalForm();
                throw new RuntimeException(msg, e);
            }
        }
        if ((urlString = urlProperties.getProperty(propertyName)) == null) {
            String msg = "Configuration error: " + propertiesUrl.toExternalForm() + " does not specify a value for the property " + propertyName;
            throw new RuntimeException(msg);
        }
        try {
            URL querySchemaUrl = new URL(urlString);
            return querySchemaUrl;
        }
        catch (IOException e) {
            String msg = "Error parsing URL that was specified as the value of the " + propertyName + " property in " + propertiesUrl.toExternalForm();
            msg = msg + "\nThe problem URL is " + urlString;
            throw new RuntimeException(msg, e);
        }
    }

    protected static String nullAsEmptyString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }
}

