/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.CountColumnSpec;
import org.protempa.dest.table.Link;
import org.protempa.xml.AbstractConverter;

class CountColumnSpecConverter
extends AbstractConverter {
    private static final String COUNT_UNIQUE = "countUnique";
    private static final String COLUMN_NAME_OVERRIDE = "columnNameOverride";
    private static final String LINKS = "links";

    CountColumnSpecConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return CountColumnSpec.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        CountColumnSpec columnSpec = (CountColumnSpec)source;
        String columnNameOverride = columnSpec.getColumnNameOverride();
        if (columnNameOverride != null) {
            writer.addAttribute(COLUMN_NAME_OVERRIDE, columnNameOverride);
        }
        writer.addAttribute(COUNT_UNIQUE, Boolean.toString(columnSpec.isCountUnique()));
        writer.startNode(LINKS);
        context.convertAnother((Object)columnSpec.getLinks());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String columnNameOverride = reader.getAttribute(COLUMN_NAME_OVERRIDE);
        String countUniqueString = this.requiredAttributeValue(reader, COUNT_UNIQUE);
        boolean countUnique = Boolean.valueOf(countUniqueString);
        reader.moveDown();
        this.expect(reader, LINKS);
        Link[] links = (Link[])context.convertAnother(null, Link[].class);
        reader.moveUp();
        this.expectNoMore(reader);
        return new CountColumnSpec(columnNameOverride, links, countUnique);
    }
}

