/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Date;
import org.protempa.KnowledgeSource;
import org.protempa.backend.dsb.filter.DateTimeFilter;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.Granularity;
import org.protempa.xml.AbstractConverter;
import org.protempa.xml.GranularityValueConverter;
import org.protempa.xml.MillisecondsValueConverter;
import org.protempa.xml.PropIDsConverter;
import org.protempa.xml.XMLConfiguration;

class DateTimeFilterConverter
extends AbstractConverter {
    private static final String PROPOSITION_IDS = "propositionIDs";
    private static final String FINISH_SIDE = "finishSide";
    private static final String START_SIDE = "startSide";
    private static final String FINISH_GRANULARITY = "finishGranularity";
    private static final String FINISH = "finish";
    private static final String START_GRANULARITY = "startGranularity";
    private static final String START = "start";
    private MillisecondsValueConverter msConverter = new MillisecondsValueConverter();

    DateTimeFilterConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class clazz) {
        return DateTimeFilter.class.equals((Object)clazz);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        DateTimeFilter filter = (DateTimeFilter)value;
        writer.addAttribute(START, this.msConverter.toString(filter.getStart()));
        GranularityValueConverter granularityConverter = new GranularityValueConverter();
        writer.addAttribute(START_GRANULARITY, granularityConverter.toString(filter.getStartGranularity()));
        writer.addAttribute(FINISH, this.msConverter.toString(filter.getFinish()));
        writer.addAttribute(FINISH_GRANULARITY, granularityConverter.toString(filter.getFinishGranularity()));
        writer.addAttribute(START_SIDE, filter.getStartSide().name());
        writer.addAttribute(FINISH_SIDE, filter.getFinishSide().name());
        writer.startNode(PROPOSITION_IDS);
        PropIDsConverter propIdsConverter = new PropIDsConverter(this.getKnowledgeSource());
        context.convertAnother((Object)filter.getPropositionIds(), (Converter)propIdsConverter);
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Date start = (Date)XMLConfiguration.STANDARD_DATE_CONVERTER.fromString(reader.getAttribute(START));
        GranularityValueConverter granularityConverter = new GranularityValueConverter();
        String startGranularityString = reader.getAttribute(START_GRANULARITY);
        Granularity startGranularity = (Granularity)granularityConverter.fromString(startGranularityString);
        Date finish = (Date)XMLConfiguration.STANDARD_DATE_CONVERTER.fromString(reader.getAttribute(FINISH));
        String finishGranularityString = reader.getAttribute(FINISH_GRANULARITY);
        Granularity finishGranularity = (Granularity)granularityConverter.fromString(finishGranularityString);
        String startSideString = reader.getAttribute(START_SIDE);
        Interval.Side startSide = Interval.Side.valueOf(startSideString);
        String finishSideString = reader.getAttribute(FINISH_SIDE);
        Interval.Side finishSide = Interval.Side.valueOf(finishSideString);
        this.expectChildren(reader);
        reader.moveDown();
        this.expect(reader, PROPOSITION_IDS);
        String[] propostionsIds = (String[])context.convertAnother(null, String[].class, (Converter)new PropIDsConverter(this.getKnowledgeSource()));
        reader.moveUp();
        return new DateTimeFilter(propostionsIds, start, startGranularity, finish, finishGranularity, startSide, finishSide);
    }
}

