/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.mvel.ConversionException;
import org.protempa.proposition.value.AbsoluteTimeGranularity;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.RelativeDayGranularity;
import org.protempa.proposition.value.RelativeHourGranularity;

class GranularityValueConverter
implements SingleValueConverter {
    private static final String SECOND = "second";
    private static final String MINUTE = "minute";
    private static final String HOUR = "hour";
    private static final String DAY = "day";
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private static final String RELATIVE_DAY = "relativeDay";
    private static final String RELATIVE_HOUR = "relativeHour";

    GranularityValueConverter() {
    }

    public boolean canConvert(Class clazz) {
        return Granularity.class.isAssignableFrom(clazz);
    }

    public Object fromString(String s) {
        if (SECOND.equals(s)) {
            return AbsoluteTimeGranularity.SECOND;
        }
        if (MINUTE.equals(s)) {
            return AbsoluteTimeGranularity.MINUTE;
        }
        if (HOUR.equals(s)) {
            return AbsoluteTimeGranularity.HOUR;
        }
        if (DAY.equals(s)) {
            return AbsoluteTimeGranularity.DAY;
        }
        if (MONTH.equals(s)) {
            return AbsoluteTimeGranularity.MONTH;
        }
        if (YEAR.equals(s)) {
            return AbsoluteTimeGranularity.YEAR;
        }
        if (RELATIVE_DAY.equals(s)) {
            return RelativeDayGranularity.DAY;
        }
        if (RELATIVE_HOUR.equals(s)) {
            return RelativeHourGranularity.HOUR;
        }
        throw new ConversionException("Unrecognized granularity value: " + s);
    }

    public String toString(Object obj) {
        if (obj == AbsoluteTimeGranularity.SECOND) {
            return SECOND;
        }
        if (obj == AbsoluteTimeGranularity.MINUTE) {
            return MINUTE;
        }
        if (obj == AbsoluteTimeGranularity.HOUR) {
            return HOUR;
        }
        if (obj == AbsoluteTimeGranularity.DAY) {
            return DAY;
        }
        if (obj == AbsoluteTimeGranularity.MONTH) {
            return MONTH;
        }
        if (obj == AbsoluteTimeGranularity.YEAR) {
            return YEAR;
        }
        if (obj == RelativeDayGranularity.DAY) {
            return DAY;
        }
        if (obj == RelativeHourGranularity.HOUR) {
            return HOUR;
        }
        throw new ConversionException("Encountered granularity object with no known string representation: " + obj);
    }
}

