/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.BigDecimalConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.math.BigDecimal;
import org.protempa.KnowledgeSource;
import org.protempa.proposition.value.NumberValue;
import org.protempa.xml.AbstractConverter;

class NumberValueObjectConverter
extends AbstractConverter {
    private final BigDecimalConverter bdconv = new BigDecimalConverter();

    NumberValueObjectConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class clazz) {
        return clazz == NumberValue.class;
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        NumberValue nval = (NumberValue)value;
        writer.setValue(this.bdconv.toString((Object)nval.getBigDecimal()));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        BigDecimal nval = (BigDecimal)this.bdconv.fromString(reader.getValue());
        return NumberValue.getInstance(nval);
    }
}

