/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.PropertyConstraint;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.xml.AbstractConverter;
import org.protempa.xml.PropertyConstraintConverter;

class PropertyConstraintsConverter
extends AbstractConverter {
    private static final String PROPERTY_CONSTRAINT_VALUE_LIST = "propertyConstraintValueList";
    private static final String PROPERTY_CONSTRAINT = "propertyConstraint";
    private static final Set<String> propertyConstraintTags = new HashSet<String>();

    PropertyConstraintsConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
    }

    public boolean canConvert(Class type) {
        return PropertyConstraint[].class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        PropertyConstraint[] constraints = (PropertyConstraint[])source;
        if (constraints.length == 0) {
            return;
        }
        PropertyConstraintConverter converter = new PropertyConstraintConverter(this.getKnowledgeSource());
        for (PropertyConstraint constraint : constraints) {
            ValueComparator comparator = constraint.getValueComparator();
            if (comparator.equals((Object)ValueComparator.IN) || comparator.equals((Object)ValueComparator.NOT_IN)) {
                writer.startNode(PROPERTY_CONSTRAINT_VALUE_LIST);
            } else {
                writer.startNode(PROPERTY_CONSTRAINT);
            }
            context.convertAnother((Object)constraint, (Converter)converter);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        this.expectChildren(reader);
        PropertyConstraintConverter converter = new PropertyConstraintConverter(this.getKnowledgeSource());
        ArrayList<PropertyConstraint> constraints = new ArrayList<PropertyConstraint>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            this.expect(reader, propertyConstraintTags);
            constraints.add((PropertyConstraint)context.convertAnother(null, PropertyConstraint.class, (Converter)converter));
            reader.moveUp();
        }
        return constraints.toArray(new PropertyConstraint[constraints.size()]);
    }

    static {
        propertyConstraintTags.add(PROPERTY_CONSTRAINT);
        propertyConstraintTags.add(PROPERTY_CONSTRAINT_VALUE_LIST);
    }
}

