/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Comparator;
import org.mvel.ConversionException;
import org.protempa.KnowledgeSource;
import org.protempa.dest.table.PropertyConstraint;
import org.protempa.dest.table.Reference;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.comparator.AllPropositionIntervalComparator;
import org.protempa.xml.AbstractConverter;
import org.protempa.xml.PropIDsConverter;
import org.protempa.xml.PropertyConstraintsConverter;
import org.protempa.xml.ReferenceNamesConverter;

class ReferenceConverter
extends AbstractConverter
implements Converter {
    private static final String PROPERTY_CONSTRAINTS = "propertyConstraints";
    private static final String PROPOSITION_IDS = "propositionIDs";
    private static final String REFERENCE_NAMES = "referenceNames";
    private static final String ALL_PROPOSITION_INTERVAL_COMPARATOR = "AllPropositionIntervalComparator";
    private static final String PROPOSITION_COMPARATOR = "propositionComparator";
    private static final String TO_INDEX = "toIndex";
    private static final String FROM_INDEX = "fromIndex";
    private final KnowledgeSource knowledgeSource;

    ReferenceConverter(KnowledgeSource knowledgeSource) {
        super(knowledgeSource);
        this.knowledgeSource = knowledgeSource;
    }

    public boolean canConvert(Class type) {
        return Reference.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        PropertyConstraint[] constraints;
        String[] propositionIDs;
        String[] referenceNames;
        Reference reference = (Reference)source;
        writer.addAttribute(FROM_INDEX, Integer.toString(reference.getFromIndex()));
        writer.addAttribute(TO_INDEX, Integer.toString(reference.getToIndex()));
        if (reference.getComparator() != null) {
            if (!(reference.getComparator() instanceof AllPropositionIntervalComparator)) {
                String msg = "Unable to convert reference comparator to XML. This conversion is implemented only for instances of " + AllPropositionIntervalComparator.class.getName() + " but the comparator is an instance of " + reference.getComparator().getClass().getName();
                throw new ConversionException(msg);
            }
            writer.addAttribute(PROPOSITION_COMPARATOR, ALL_PROPOSITION_INTERVAL_COMPARATOR);
        }
        if ((referenceNames = reference.getReferenceNames()) != null && referenceNames.length > 0) {
            writer.startNode(REFERENCE_NAMES);
            ReferenceNamesConverter converter = new ReferenceNamesConverter(this.getKnowledgeSource());
            context.convertAnother((Object)referenceNames, (Converter)converter);
            writer.endNode();
        }
        if ((propositionIDs = reference.getPropositionIds()) != null && propositionIDs.length > 0) {
            writer.startNode(PROPOSITION_IDS);
            PropIDsConverter converter = new PropIDsConverter(this.getKnowledgeSource());
            context.convertAnother((Object)propositionIDs, (Converter)converter);
            writer.endNode();
        }
        if ((constraints = reference.getConstraints()) != null && constraints.length > 0) {
            writer.startNode(PROPERTY_CONSTRAINTS);
            PropertyConstraintsConverter converter = new PropertyConstraintsConverter(this.getKnowledgeSource());
            context.convertAnother((Object)constraints, (Converter)converter);
            writer.endNode();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        AllPropositionIntervalComparator comparator;
        int fromIndex = this.intAttributeValue(reader, FROM_INDEX, -1);
        int toIndex = this.intAttributeValue(reader, TO_INDEX, -1);
        String comparatorString = reader.getAttribute(PROPOSITION_COMPARATOR);
        if (comparatorString != null) {
            if (!ALL_PROPOSITION_INTERVAL_COMPARATOR.equals(comparatorString)) {
                String msg = "XML specifies unsupported value for propositionComparator";
                throw new ConversionException(msg);
            }
            comparator = new AllPropositionIntervalComparator();
        } else {
            comparator = null;
        }
        String[] referenceNames = null;
        String[] propositionIds = null;
        PropertyConstraint[] constraints = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (REFERENCE_NAMES.equals(reader.getNodeName())) {
                if (referenceNames != null) {
                    String string = "referenceNames element is specified more than once.";
                    throw new ConversionException(string);
                }
                ReferenceNamesConverter referenceNamesConverter = new ReferenceNamesConverter(this.getKnowledgeSource());
                referenceNames = (String[])context.convertAnother(null, String[].class, (Converter)referenceNamesConverter);
            } else if (PROPOSITION_IDS.equals(reader.getNodeName())) {
                if (propositionIds != null) {
                    String string = "propositionIDs element is specified more than once.";
                    throw new ConversionException(string);
                }
                PropIDsConverter propIDsConverter = new PropIDsConverter(this.getKnowledgeSource());
                propositionIds = (String[])context.convertAnother(null, String[].class, (Converter)propIDsConverter);
            } else if (PROPERTY_CONSTRAINTS.equals(reader.getNodeName())) {
                if (constraints != null) {
                    String string = "propertyConstraints element is specified more than once.";
                    throw new ConversionException(string);
                }
                PropertyConstraintsConverter propertyConstraintsConverter = new PropertyConstraintsConverter(this.getKnowledgeSource());
                constraints = (PropertyConstraint[])context.convertAnother(null, PropertyConstraint[].class, (Converter)propertyConstraintsConverter);
            }
            reader.moveUp();
        }
        return new Reference(referenceNames, propositionIds, constraints, (Comparator<Proposition>)comparator, fromIndex, toIndex);
    }
}

