/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.protempa.AlgorithmSource;
import org.protempa.AlgorithmSourceImpl;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceImpl;
import org.protempa.backend.asb.AlgorithmSourceBackend;
import org.protempa.backend.dsb.filter.AbstractFilter;
import org.protempa.backend.dsb.filter.DateTimeFilter;
import org.protempa.backend.dsb.filter.PositionFilter;
import org.protempa.backend.dsb.filter.PropertyValueFilter;
import org.protempa.backend.ksb.KnowledgeSourceBackend;
import org.protempa.dest.table.AtLeastNColumnSpec;
import org.protempa.dest.table.CountColumnSpec;
import org.protempa.dest.table.Derivation;
import org.protempa.dest.table.DistanceBetweenColumnSpec;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.OutputConfig;
import org.protempa.dest.table.PropositionColumnSpec;
import org.protempa.dest.table.PropositionValueColumnSpec;
import org.protempa.dest.table.Reference;
import org.protempa.dest.table.TableDestination;
import org.protempa.dest.table.ValueOutputConfig;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.query.Query;
import org.protempa.query.QueryBuildException;
import org.protempa.query.QueryBuilder;
import org.protempa.xml.AtLeastNColumnSpecConverter;
import org.protempa.xml.BooleanValueObjectConverter;
import org.protempa.xml.CharacterToReferenceWriter;
import org.protempa.xml.CountColumnSpecConverter;
import org.protempa.xml.DateTimeFilterConverter;
import org.protempa.xml.DateValueObjectConverter;
import org.protempa.xml.DerivationConverter;
import org.protempa.xml.DistanceBetweenColumnSpecConverter;
import org.protempa.xml.GranularityValueConverter;
import org.protempa.xml.InequalityValueObjectConverter;
import org.protempa.xml.LinksConverter;
import org.protempa.xml.NominalValueObjectConverter;
import org.protempa.xml.NumberValueObjectConverter;
import org.protempa.xml.OutputConfigConverter;
import org.protempa.xml.PropIDsConverter;
import org.protempa.xml.PropositionColumnSpecConverter;
import org.protempa.xml.PropositionValueColumnSpecConverter;
import org.protempa.xml.QueryConverter;
import org.protempa.xml.ReferenceConverter;
import org.protempa.xml.TableColumnSpecsConverter;
import org.protempa.xml.TableQueryResultsHandlerConverter;
import org.protempa.xml.ValueComparatorValueConverter;
import org.protempa.xml.ValueOutputConfigConverter;
import org.protempa.xml.XStreamWrapper;

public class XMLConfiguration
implements QueryBuilder {
    static final DateConverter STANDARD_DATE_CONVERTER = new DateConverter("yyyy-MM-dd'T'HH:mm:ss.S", new String[0], TimeZone.getDefault());
    private static final Logger myLogger = Logger.getLogger(XMLConfiguration.class.getName());
    private static final ThreadLocal<Boolean> surpressSchemaReference = new ThreadLocal();
    private final File file;
    private static XStream tableQueryResultsHandlerXStream;

    public XMLConfiguration(File file) {
        this.file = file;
    }

    private static synchronized XStream getXStream(KnowledgeSource knowledgeSource) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.setMode(1001);
        xstream.registerConverter((SingleValueConverter)STANDARD_DATE_CONVERTER, 10000);
        xstream.alias("booleanValue", BooleanValue.class);
        xstream.registerConverter((Converter)new BooleanValueObjectConverter(knowledgeSource));
        xstream.useAttributeFor(PropertyValueFilter.class, "valueComparator");
        xstream.aliasField("comparator", PropertyValueFilter.class, "valueComparator");
        xstream.registerConverter((SingleValueConverter)new ValueComparatorValueConverter());
        xstream.alias("dateTimeFilter", DateTimeFilter.class);
        xstream.registerConverter((Converter)new DateTimeFilterConverter(knowledgeSource));
        xstream.alias("dateValue", DateValue.class);
        xstream.registerConverter((Converter)new DateValueObjectConverter());
        xstream.omitField(AbstractFilter.class, "and");
        xstream.aliasField("propositionIDs", AbstractFilter.class, "propositionIds");
        xstream.registerLocalConverter(AbstractFilter.class, "propositionIds", (Converter)new PropIDsConverter(knowledgeSource));
        xstream.useAttributeFor(PositionFilter.class, "finish");
        xstream.useAttributeFor(PositionFilter.class, "finishGran");
        xstream.aliasField("finishGranularity", PositionFilter.class, "finishGran");
        xstream.useAttributeFor(PositionFilter.class, "finishSide");
        xstream.registerConverter((SingleValueConverter)new GranularityValueConverter());
        xstream.alias("incomparableNumberValue", InequalityNumberValue.class);
        xstream.registerConverter((Converter)new InequalityValueObjectConverter(knowledgeSource));
        xstream.alias("nominalValue", NominalValue.class);
        xstream.registerConverter((Converter)new NominalValueObjectConverter(knowledgeSource));
        xstream.alias("numberValue", NumberValue.class);
        xstream.registerConverter((Converter)new NumberValueObjectConverter(knowledgeSource));
        xstream.omitField(PositionFilter.class, "ival");
        xstream.alias("positionFilter", PositionFilter.class);
        xstream.useAttributeFor(PropertyValueFilter.class, "property");
        xstream.aliasField("propertyName", PropertyValueFilter.class, "property");
        xstream.alias("propertyValueFilter", PropertyValueFilter.class);
        xstream.alias("propertyValuesFilter", PropertyValueFilter.class);
        xstream.addImplicitArray(PropertyValueFilter.class, "values");
        xstream.useAttributeFor(PositionFilter.class, "start");
        xstream.useAttributeFor(PositionFilter.class, "startGran");
        xstream.aliasField("startGranularity", PositionFilter.class, "startGran");
        xstream.useAttributeFor(PositionFilter.class, "startSide");
        xstream.alias("tableQueryResultsHandler", TableDestination.class);
        xstream.registerConverter((Converter)new TableQueryResultsHandlerConverter(knowledgeSource));
        return xstream;
    }

    private static synchronized XStream getXStream(KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource) {
        XStream xstream = XMLConfiguration.getXStream(knowledgeSource);
        xstream.alias("protempaQuery", Query.class);
        xstream.registerConverter((Converter)new QueryConverter(knowledgeSource, algorithmSource));
        return xstream;
    }

    public static Query readQueryAsXML(File file, KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource) throws IOException {
        myLogger.entering(XMLConfiguration.class.getName(), "readQueryAsXML");
        Query query = (Query)XMLConfiguration.getXStream(knowledgeSource, algorithmSource).fromXML(file);
        return query;
    }

    public static Query readQueryAsXML(URL url, KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource) throws IOException {
        myLogger.entering(XMLConfiguration.class.getName(), "readQueryAsXML");
        Query query = (Query)XMLConfiguration.getXStream(knowledgeSource, algorithmSource).fromXML(url);
        return query;
    }

    public static Query readQueryAsXML(Reader reader, KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource) throws IOException {
        myLogger.entering(XMLConfiguration.class.getName(), "readQueryAsXML");
        Query query = (Query)XMLConfiguration.getXStream(knowledgeSource, algorithmSource).fromXML(reader);
        return query;
    }

    public static Query readQueryAsXML(InputStream inputStream, KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource) throws IOException {
        myLogger.entering(XMLConfiguration.class.getName(), "readQueryAsXML");
        Query query = (Query)XMLConfiguration.getXStream(knowledgeSource, algorithmSource).fromXML(inputStream);
        return query;
    }

    public static Query readQueryAsXML(String str, KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource) throws IOException {
        myLogger.entering(XMLConfiguration.class.getName(), "readQueryAsXML");
        Query query = (Query)XMLConfiguration.getXStream(knowledgeSource, algorithmSource).fromXML(str);
        return query;
    }

    public static void writeQueryAsXML(Query query, File file) throws IOException {
        XMLConfiguration.writeQueryAsXML(query, file, false);
    }

    public static void writeQueryAsXML(Query query, File file, boolean surpressSchemaReference) throws IOException {
        FileWriter writer = new FileWriter(file);
        XMLConfiguration.writeQueryAsXML(query, writer, surpressSchemaReference);
    }

    public static void writeQueryAsXML(Query query, Writer writer, boolean surpressSchemaReference) throws IOException {
        XMLConfiguration.surpressSchemaReference.set(surpressSchemaReference);
        myLogger.entering(XMLConfiguration.class.getName(), "writeQueryAsXML");
        XMLConfiguration.getXStream(new KnowledgeSourceImpl(new KnowledgeSourceBackend[0]), new AlgorithmSourceImpl(new AlgorithmSourceBackend[0])).toXML((Object)query, writer);
        writer.close();
        myLogger.exiting(XMLConfiguration.class.getName(), "writeQueryAsXML");
    }

    static XStream getTableQueryResultsHandlerXStream(KnowledgeSource knowledgeSource) {
        if (tableQueryResultsHandlerXStream != null) {
            return tableQueryResultsHandlerXStream;
        }
        XStream xstream = XMLConfiguration.getXStream(knowledgeSource);
        xstream.registerLocalConverter(AbstractFilter.class, "rowPropositionIds", (Converter)new TableColumnSpecsConverter(knowledgeSource));
        xstream.alias("atLeastNColumnSpec", AtLeastNColumnSpec.class);
        xstream.registerConverter((Converter)new AtLeastNColumnSpecConverter(knowledgeSource));
        xstream.alias("countColumnSpec", CountColumnSpec.class);
        xstream.registerConverter((Converter)new CountColumnSpecConverter(knowledgeSource));
        xstream.alias("distanceBetweenColumnSpec", DistanceBetweenColumnSpec.class);
        xstream.registerConverter((Converter)new DistanceBetweenColumnSpecConverter(knowledgeSource));
        xstream.alias("propositionColumnSpec", PropositionColumnSpec.class);
        xstream.registerConverter((Converter)new PropositionColumnSpecConverter(knowledgeSource));
        xstream.alias("propositionValueColumnSpec", PropositionValueColumnSpec.class);
        xstream.registerConverter((Converter)new PropositionValueColumnSpecConverter(knowledgeSource));
        xstream.alias("links", Link[].class);
        xstream.registerConverter((Converter)new LinksConverter(knowledgeSource));
        xstream.alias("outputConfig", OutputConfig.class);
        xstream.registerConverter((Converter)new OutputConfigConverter(knowledgeSource));
        xstream.alias("valueOutputConfig", ValueOutputConfig.class);
        xstream.registerConverter((Converter)new ValueOutputConfigConverter(knowledgeSource));
        xstream.alias("derivation", Derivation.class);
        xstream.registerConverter((Converter)new DerivationConverter(knowledgeSource));
        xstream.alias("reference", Reference.class);
        xstream.registerConverter((Converter)new ReferenceConverter(knowledgeSource));
        tableQueryResultsHandlerXStream = new XStreamWrapper(xstream);
        return tableQueryResultsHandlerXStream;
    }

    public static TableDestination readTableQueryResultsHandlerFactoryAsXML(File file, BufferedWriter dataWriter, KnowledgeSource knowledgeSource) throws IOException {
        myLogger.entering(XMLConfiguration.class.getName(), "readTableQueryResultsHandlerAsXML");
        return (TableDestination)XMLConfiguration.getTableQueryResultsHandlerXStream(knowledgeSource).fromXML(file);
    }

    public static TableDestination readTableQueryResultsHandlerAsXML(URL url, BufferedWriter dataWriter, KnowledgeSource knowledgeSource) throws IOException {
        myLogger.entering(XMLConfiguration.class.getName(), "readTableQueryResultsHandlerAsXML");
        return (TableDestination)XMLConfiguration.getTableQueryResultsHandlerXStream(knowledgeSource).fromXML(url);
    }

    public static TableDestination readTableQueryResultsHandlerAsXML(Reader reader, BufferedWriter dataWriter, KnowledgeSource knowledgeSource) throws IOException {
        myLogger.entering(XMLConfiguration.class.getName(), "readTableQueryResultsHandlerAsXML");
        return (TableDestination)XMLConfiguration.getTableQueryResultsHandlerXStream(knowledgeSource).fromXML(reader);
    }

    public static TableDestination readTableQueryResultsHandlerAsXML(InputStream inputStream, BufferedWriter dataWriter, KnowledgeSource knowledgeSource) throws IOException {
        myLogger.entering(XMLConfiguration.class.getName(), "readTableQueryResultsHandlerAsXML");
        return (TableDestination)XMLConfiguration.getTableQueryResultsHandlerXStream(knowledgeSource).fromXML(inputStream);
    }

    public static TableDestination readTableQueryResultsHandlerAsXML(String str, BufferedWriter dataWriter, KnowledgeSource knowledgeSource) throws IOException {
        myLogger.entering(XMLConfiguration.class.getName(), "readTableQueryResultsHandlerAsXML");
        return (TableDestination)XMLConfiguration.getTableQueryResultsHandlerXStream(knowledgeSource).fromXML(str);
    }

    static TableDestination readTableDestinationAsXML(HierarchicalStreamReader hsr, BufferedWriter dataWriter, KnowledgeSource knowledgeSource) {
        myLogger.entering(XMLConfiguration.class.getName(), "readTableQueryResultsHandlerAsXML");
        MapBackedDataHolder dataHolder = new MapBackedDataHolder();
        dataHolder.put((Object)"writer", (Object)dataWriter);
        TableDestination destination = (TableDestination)XMLConfiguration.getTableQueryResultsHandlerXStream(knowledgeSource).unmarshal(hsr, null, (DataHolder)dataHolder);
        myLogger.exiting(XMLConfiguration.class.getName(), "readTableQueryResultsHandlerAsXML");
        return destination;
    }

    public static void writeTableDestinationAsXML(TableDestination destination, File file, KnowledgeSource knowledgeSource) throws IOException {
        XMLConfiguration.writeTableDestinationAsXML(destination, file, false, knowledgeSource);
    }

    public static void writeTableDestinationAsXML(TableDestination destination, File file, boolean surpressSchemaReference, KnowledgeSource knowledgeSource) throws IOException {
        FileWriter writer = new FileWriter(file);
        XMLConfiguration.writeTableDestinationAsXML(destination, writer, surpressSchemaReference, knowledgeSource);
    }

    public static void writeTableDestinationAsXML(TableDestination destination, Writer writer, boolean surpressSchemaReference, KnowledgeSource knowledgeSource) throws IOException {
        XMLConfiguration.surpressSchemaReference.set(surpressSchemaReference);
        myLogger.entering(XMLConfiguration.class.getName(), "writeQueryAsXML");
        XStream xstream = XMLConfiguration.getTableQueryResultsHandlerXStream(knowledgeSource);
        CharacterToReferenceWriter ctrw = new CharacterToReferenceWriter(writer);
        xstream.toXML((Object)destination, (Writer)ctrw);
        ctrw.close();
        myLogger.exiting(XMLConfiguration.class.getName(), "writeQueryAsXML");
    }

    static boolean isSurpressSchemaReferenceRequested() {
        return surpressSchemaReference.get().equals(Boolean.TRUE);
    }

    @Override
    public Query build(KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource) throws QueryBuildException {
        try {
            return XMLConfiguration.readQueryAsXML(this.file, knowledgeSource, algorithmSource);
        }
        catch (IOException e) {
            throw new QueryBuildException("Error building query from XML", e);
        }
    }
}

