/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.command.LogHandler;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;

class TranslatingEntryVisitor
implements Visitor<LogEntry, IOException> {
    private LogEntryStart startEntry;
    private LogHandler handler;
    private List<LogEntry> entries;
    private final Function<List<LogEntry>, List<LogEntry>> translator;

    TranslatingEntryVisitor(Function<List<LogEntry>, List<LogEntry>> translator) {
        this.translator = translator;
    }

    @Override
    public boolean visit(LogEntry logEntry) throws IOException {
        if (this.startEntry == null) {
            if (logEntry == null || logEntry.getType() != 1) {
                throw new IOException("Unable to find start entry");
            }
            this.startEntry = (LogEntryStart)logEntry;
        }
        if (logEntry.getVersion() != -2) {
            if (this.entries == null) {
                this.entries = new LinkedList<LogEntry>();
            }
            this.entries.add(logEntry);
            if (logEntry.getType() == 5) {
                this.entries = (List)this.translator.apply(this.entries);
                for (LogEntry entry : this.entries) {
                    entry.accept(this.handler);
                }
                this.entries = null;
            }
        } else {
            logEntry.accept(this.handler);
        }
        return true;
    }

    public TranslatingEntryVisitor bind(LogHandler handler) {
        this.handler = handler;
        this.entries = null;
        return this;
    }
}

