/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Collections {
    private Collections() {
    }

    public static <K, V> void putList(Map<K, List<V>> map, K key, V valueElt) {
        if (map.containsKey(key)) {
            List<V> l = map.get(key);
            l.add(valueElt);
        } else {
            ArrayList<V> l = new ArrayList<V>();
            l.add(valueElt);
            map.put(key, l);
        }
    }

    public static <K, V> void putListMult(Map<K, List<V>> map, K key, Collection<? extends V> values) {
        for (V value : values) {
            Collections.putList(map, key, value);
        }
    }

    public static <K, V> void putSet(Map<K, Set<V>> map, K key, V valueElt) {
        if (map.containsKey(key)) {
            Set<V> l = map.get(key);
            l.add(valueElt);
        } else {
            HashSet<V> l = new HashSet<V>();
            l.add(valueElt);
            map.put(key, l);
        }
    }

    public static <K, V> void putSetMult(Map<K, Set<V>> map, K key, Collection<? extends V> values) {
        for (V value : values) {
            Collections.putSet(map, key, value);
        }
    }

    public static <K, V> void putSetAll(Map<K, Set<V>> map, Map<K, Set<V>> other) {
        for (Map.Entry<K, Set<V>> me : other.entrySet()) {
            Collections.putSetMult(map, me.getKey(), (Collection)me.getValue());
        }
    }

    public static <K> boolean containsAny(Set<K> aSet, K[] arr) {
        for (K obj : arr) {
            if (!aSet.contains(obj)) continue;
            return true;
        }
        return false;
    }

    public static <K> Set<K> intersection(Collection<Set<K>> sets) {
        boolean firstPass = true;
        HashSet<K> result = new HashSet<K>();
        for (Set<K> set : sets) {
            if (firstPass) {
                result.addAll(set);
                firstPass = false;
                continue;
            }
            result.retainAll(set);
        }
        return result;
    }

    @SafeVarargs
    public static <K> Set<K> intersection(Set<K> ... sets) {
        boolean firstPass = true;
        HashSet<K> result = new HashSet<K>();
        for (Set<K> set : sets) {
            if (firstPass) {
                result.addAll(set);
                firstPass = false;
                continue;
            }
            result.retainAll(set);
        }
        return result;
    }
}

