/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.datastore;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.datastore.DataStore;
import org.arp.javautil.datastore.DataStoreError;
import org.arp.javautil.datastore.EnvironmentInfo;

public class BdbMap<K, V>
implements DataStore<K, V> {
    private final Database db;
    private final StoredMap<K, V> storedMap;
    private boolean isClosed;
    private EnvironmentInfo envInfo;

    BdbMap(EnvironmentInfo envInfo, Database database) throws DataStoreError {
        this.db = database;
        this.envInfo = envInfo;
        StoredClassCatalog catalog = envInfo.getClassCatalog();
        try {
            SerialBinding kBinding = new SerialBinding((ClassCatalog)catalog, null);
            SerialBinding vBinding = new SerialBinding((ClassCatalog)catalog, null);
            this.storedMap = new StoredMap(this.db, (EntryBinding)kBinding, (EntryBinding)vBinding, true);
        }
        catch (DatabaseException ex) {
            throw new DataStoreError(ex);
        }
    }

    @Override
    public void shutdown() {
        this.envInfo.closeAndRemoveDatabaseHandle(this.db);
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void clear() {
        this.storedMap.clear();
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.storedMap.containsKey(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.storedMap.containsValue(arg0);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.storedMap.entrySet();
    }

    @Override
    public V get(Object arg0) {
        return (V)this.storedMap.get(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.storedMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.storedMap.keySet();
    }

    @Override
    public V put(K arg0, V arg1) {
        return (V)this.storedMap.put(arg0, arg1);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> arg0) {
        this.storedMap.putAll(arg0);
    }

    @Override
    public V remove(Object arg0) {
        return (V)this.storedMap.remove(arg0);
    }

    @Override
    public int size() {
        return this.storedMap.size();
    }

    @Override
    public Collection<V> values() {
        return this.storedMap.values();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BdbMap other = (BdbMap)obj;
        return this.storedMap == other.storedMap || this.storedMap != null && this.storedMap.equals(other.storedMap);
    }

    @Override
    public int hashCode() {
        return this.storedMap.hashCode();
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }
}

