/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.datastore;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.arp.javautil.datastore.DataStoreUtil;

@Deprecated
class CacheDatabase {
    private static final String CLASS_CATALOG = "java_class_catalog";
    private static StoredClassCatalog classCatalog;
    private static Environment env;
    private static File location;
    private static Map<String, Database> maps;

    CacheDatabase() {
    }

    static Database createDatabase(String dbName) throws DatabaseException {
        CacheDatabase.createEnvironmentIfNeeded();
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setTemporary(true);
        Database result = env.openDatabase(null, dbName, dbConfig);
        if (maps.put(dbName, result) != null) {
            throw new AssertionError((Object)"This shouldn't happen");
        }
        return result;
    }

    static ClassCatalog createOrGetClassCatalog() throws DatabaseException {
        CacheDatabase.createEnvironmentIfNeeded();
        CacheDatabase.createClassCatalogIfNeeded();
        return classCatalog;
    }

    private static synchronized void createClassCatalogIfNeeded() throws IllegalArgumentException, DatabaseException {
        if (classCatalog == null) {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setTemporary(true);
            dbConfig.setAllowCreate(true);
            Database catalogDb = env.openDatabase(null, CLASS_CATALOG, dbConfig);
            classCatalog = new StoredClassCatalog(catalogDb);
        }
    }

    private static synchronized void createEnvironmentIfNeeded() throws DatabaseException {
        if (env == null) {
            EnvironmentConfig envConf = new EnvironmentConfig();
            envConf.setAllowCreate(true);
            envConf.setTransactional(true);
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
            long max = memoryUsage.getMax();
            long used = memoryUsage.getUsed();
            long available = max - used;
            long cacheSize = Math.round((double)available / 2.0);
            envConf.setCacheSize(cacheSize);
            DataStoreUtil.logger().log(Level.FINE, "Cache size set to {0} bytes", cacheSize);
            if (!location.exists()) {
                location.mkdirs();
            }
            env = new Environment(location, envConf);
        }
    }

    static {
        maps = Collections.synchronizedMap(new HashMap());
        location = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        Runtime.getRuntime().addShutdownHook(new Thread("CacheDBShutdownHook"){

            @Override
            public void run() {
                if (env != null) {
                    try {
                        for (Database m : maps.values()) {
                            m.close();
                        }
                        classCatalog.close();
                        env.close();
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                    }
                    for (File f : location.listFiles()) {
                        f.delete();
                    }
                    location.delete();
                }
            }
        });
    }
}

